#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>


#include <QUdpSocket>

// udp packet codes
// codici nei pacchetti UDP
typedef enum
{
    UDP_EMPTY		= 0,
    UDP_SETLIGHT	= 1,
    UDP_GETLIGHT	= 2,
    UDP_SETNAME		= 3,
    UDP_GETNAME		= 4,
    UDP_FIND		= 0x55

} UDP_PACKETS_CODES;

#define UDP_PORT		47777

namespace Ui
{
    class MainWindow;
}

class MainWindow : public QMainWindow
{
        Q_OBJECT

    public:
        explicit MainWindow(QWidget *parent = 0);
        ~MainWindow();

    private:
        Ui::MainWindow *ui;

		// the server socket
        QUdpSocket *udpSocket;

		// send an UDP packet to an host
		void sendUdpPacket(QByteArray const &packet, QHostAddress addr);

		// wait for and get an UDP packet from host
		QByteArray receiveUdpPacket(quint16 timeout, QHostAddress &sender, quint16 &port);
		QByteArray receiveUdpPacket(quint16 timeout);


	public slots:

		// discover all connected colibrì devices
        void discoverDevices(void);

		// get device values
		void getDeviceValues(int);

		// set device values
		void setDeviceValues(int);
		void setDeviceValues() { setDeviceValues(0); }

		// set device name
		void setDeviceName(QString newName);

};

#endif // MAINWINDOW_H
