#ifndef __FISHINO_COROUTINE_H
#define __FISHINO_COROUTINE_H

#define DEFAULT_STACK_SIZE 10000
#define Sequencing(S) { FishinoCoroutine::InitSequencing(DEFAULT_STACK_SIZE); S; }
#include <stddef.h>
#include <setjmp.h>

class Task;

class FishinoCoroutine
{
	protected:
		FishinoCoroutine(size_t StackSize = DEFAULT_STACK_SIZE);
		virtual void Routine() = 0;
	private:
		void Enter();
		void Eat();
		Task *MyTask;
		size_t StackSize;
		int Ready, Terminated;
		FishinoCoroutine *Caller, *Callee;
		static FishinoCoroutine *ToBeResumed;
		
		static void Resume(FishinoCoroutine *);
		static void Call(FishinoCoroutine *);

		static FishinoCoroutine *CurrentCoroutine();
		static FishinoCoroutine *MainCoroutine();

	public:
	
		// detach current coroutine
		static void Detach();

		// start / resume me
		void Resume() { Resume(this); }
		
		// start me
		void Call() { Call(this); }

		static void InitSequencing(size_t main_StackSize);
};


struct Task
{
	FishinoCoroutine *MyCoroutine;
	jmp_buf jmpb;
	int used;
	size_t size;
	struct Task *pred, *suc;
	struct Task *prev, *next;
};

#endif

