#ifndef __FISHINO_COROUTINE_H
#define __FISHINO_COROUTINE_H

#define Sequencing(S) {char Dummy; StackBottom = &Dummy; S;}
#include <stddef.h>
#include <setjmp.h>

extern char *StackBottom;

class FishinoCoroutine
{
	protected:
		FishinoCoroutine(size_t Dummy = 0);
		~FishinoCoroutine();
		virtual void Routine() = 0;
		
	private:
		void Enter();
		void StoreStack();
		void RestoreStack();
		char *StackBuffer, *Low, *High;
		size_t BufferSize;
		jmp_buf Environment;
		FishinoCoroutine *Caller, *Callee;
		static FishinoCoroutine *ToBeResumed;
		
		// start / resume a coroutine
		static void Resume(FishinoCoroutine *);
		
		// start a coroutine
		static void Call(FishinoCoroutine *);
		
		FishinoCoroutine *CurrentCoroutine();
		FishinoCoroutine *MainCoroutine();

	public:
	
		// detach current coroutine
		static void Detach();
		
		// start / resume me
		void Resume() { Resume(this); }
		
		// start me
		void Call() { Call(this); }
};

#define DEFAULT_STACK_SIZE 0

#endif
