//////////////////////////////////////////////////////////////////////////
//		FishBook - Capitolo 14 - Generazione di una sequenza di note	//
//		Generiamo una breve melodia composta da 8 note musicali			//
//////////////////////////////////////////////////////////////////////////

#include "pitches.h"

// le note nella melodia:
int melodia[] =
{
	NOTE_C4, NOTE_G3, NOTE_G3, NOTE_A3, NOTE_G3, 0, NOTE_B3, NOTE_C4
};

// le durate delle note :: 4 = un quarto, 8 = un ottavo, ecc.:
int durate[] =
{
	4, 8, 8, 4, 4, 4, 4, 4
};

void setup()
{
}

// ripete la stessa melodia all'infinito
void loop()
{
	// ciclo per le note della melodia:
	for (int nota = 0; nota < 8; nota++)
	{
		// per calcolare la durata in secondi della nota
		// divide un secondo (1000 millisecondi) per il numero
		// corrispondente nella tabella delle durate
		int durata = 1000 / durate[nota];
		tone(3, melodia[nota], durata);

		// per percepire le note separate, inserisce una pausa
		// tra le note pari al 30% della durata
		int tempoPerNota = durata * 1.30;
		delay(tempoPerNota);
	}
	
	// ritardo di mezzo secondo tra una ripetizione e l'altra
	delay(500);
}
