//////////////////////////////////////////////////////////////////////////
//	FishBook - Capitolo 17 - Lampeggio indipendente di 8 led con millis	//
//		Facciamo lampeggiare 8 led in modo totalmente indipendente		//
//		Metodo efficace utilizzando la funzione millis()				//
//////////////////////////////////////////////////////////////////////////

// gli stati degli 8 LED
bool on[8];

// i "timers" per gli 8 LED
uint32_t timers[8];

// i tempi, in millisecondi, di lampeggio per ogni LED
// possiamo cambiarli per vedere gli effetti
const uint32_t TIMES[8] = { 1000, 1200, 1500, 800, 500, 200, 3000, 700 };

void setup()
{
	// imposta tutte le porte usate come uscite a livello basso
	// imposta inoltre tutti i leds come spenti e inizializza i timers
	// (i +2 sono perchè la porta del primo led è la 2 e le altre sono in sequenza!)
	for (int led = 0; led < 8; led++)
	{
		pinMode(led + 2, OUTPUT);
		digitalWrite(led + 2, LOW);
		
		on[led] = false;
		timers[led] = millis() + TIMES[led];
	}

}

void loop()
{
	// controlla i timers di ogni LED e se necessario li scambia da spento a acceso
	// e viceversa
	for(int led = 0; led < 8; led++)
	{
		// se il tempo per il led corrente è scaduto...
		if(millis() > timers[led])
		{
			// inverte lo stato del led corrente
			on[led] = !on[led];
			
			// lo scrive sulla porta
			digitalWrite(led + 2, on[led]);
			
			// ripristina il timer per il led
			timers[led] = millis() + TIMES[led];
		}
	}
}
