//////////////////////////////////////////////////////////////////////////
//	FishBook - Capitolo 20 - Orologio con data ed ora					//
//	Sfruttiamo il modulo RTC per creare un semplice ma efficace			//
//	orologio completo di calendario e visualizzazione su display LCD	//
//////////////////////////////////////////////////////////////////////////

#include <LiquidCrystal.h>
#include <Wire.h>
#include <RTClib.h>


// il display LCD
LiquidCrystal LCD(2, 3, 5, 6, 8, 9);

// l' RTC
RTC_DS1307 rtc;

// i nomi dei mesi
const char *nomiMesi[] = {
	"Gen", "Feb", "Mar", "Apr", "Mag", "Giu",
	"Lug", "Ago", "Set", "Ott", "Nov", "Dic"
};

void setup(void)
{
	// inizializza l'LCD
	LCD.begin(16, 2);
	
	// inizializza la libreria I2C
	Wire.begin();
	
	// inizializza l' RTC
	rtc.begin();

	// se l'RTC ha perso l'ora (o se è al primo utilizzo
	// imposta l'ora a quella di compilazione dello sketch
	if (! rtc.isrunning())
		rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
	}
}

void loop(void)
{
	char oraBuf[] = "00:00:00";
	char dataBuf[] = "01 Gen 2016";
	
	// legge ora e data dall'RTC
	DateTime now = rtc.now();
	
	// prepara due righe di testo con data e ora
	sprintf(oraBuf, "%02d:%02d:%02d", now.hour(), now.minute(), now.second());
	sprintf(dataBuf, "%02d %3s %04d", now.day(), nomiMesi[now.month() - 1], now.year());

	// cancella il display
	LCD.clear();
	
	// scrive l'ora nella prima riga del display
	LCD.print(oraBuf);
	
	// si sposta sulla seconda riga del display
	// e scrive la data
	LCD.setCursor(0, 1);
	LCD.print(dataBuf);
	
	// attende un secondo
	delay(1000);
}
