//////////////////////////////////////////////////////////////////////////
//	FishBook - Capitolo 20 - Orologio con data, ora e temperatura		//
//	Completiamo il nostro orologio/datario con la visualizzazione		//
//	della temperatura ambiente rilevata tramite un sensore				//
//////////////////////////////////////////////////////////////////////////

#include <LiquidCrystal.h>
#include <Wire.h>
#include <RTClib.h>
#include <OneWire.h>
#include <DallasTemperature.h>

// il display LCD
LiquidCrystal LCD(2, 3, 5, 6, 8, 9);

// l' RTC
RTC_DS1307 rtc;

// i nomi dei mesi
const char *nomiMesi[] = {
	"Gen", "Feb", "Mar", "Apr", "Mag", "Giu",
	"Lug", "Ago", "Set", "Ott", "Nov", "Dic"
};

// imposta l'interfaccia OneWire per comunicare sul pin 14 (alias A0)
OneWire oneWire(14);

// la variabile per il sensore di temperatura
DallasTemperature tempSensors(&oneWire);

void setup(void)
{
	Serial.begin(115200);
	
	// inizializza l'LCD
	LCD.begin(16, 2);
	
	// inizializza la libreria I2C
	Wire.begin();
	
	// inizializza l' RTC
	rtc.begin();

	// se l'RTC ha perso l'ora (o se è al primo utilizzo
	// imposta l'ora a quella di compilazione dello sketch
	if (! rtc.isrunning())
		rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
	
	// inizializza il sensore di temperatura
	tempSensors.begin();
	
}

void loop(void)
{
	// 16 caratteri:    "0123456789ABCDEF"
	char oraTempBuf[] = "00:00:00  33.0°C";
	char dataBuf[]    = "01 Gen 2016";
	
	// legge ora e data dall'RTC
	DateTime now = rtc.now();
	
	// legge la temperatura dal sensore
	tempSensors.requestTemperatures();
	double temp = tempSensors.getTempCByIndex(0);
	
	// la funzione sprintf di arduino non supporta la stampa di valori
	// in virgola mobile; usiamo quindi un trucchetto scomponendo la
	// temperatura in 2 numeri interi, prendendo solo un decimale
	int iTemp = (int)temp;
	int fTemp = (int)((temp - iTemp) * 10);
	
	// prepara due righe di testo; la prima con l'ora e la temperatura...
	sprintf(oraTempBuf, "%02d:%02d:%02d  %2d.%01d C", now.hour(), now.minute(), now.second(), iTemp, fTemp);
	
	// ... e la seconda con la data
	sprintf(dataBuf, "%02d %3s %04d", now.day(), nomiMesi[now.month() - 1], now.year());

	// cancella il display
	LCD.clear();
	
	// scrive l'ora nella prima riga del display
	LCD.print(oraTempBuf);
	
	// si sposta sulla seconda riga del display
	// e scrive la data
	LCD.setCursor(0, 1);
	LCD.print(dataBuf);
	
	// attende un secondo
	delay(1000);
}
