//////////////////////////////////////////////////////////////////////////
//	FishBook - Capitolo 21 - Un semplice player audio					//
//	Realizziamo un progetto in grado di riprodurre un file musicale		//
//	contenuto in una scheda microSD										//
//////////////////////////////////////////////////////////////////////////

#include <SD.h>

// il pin CS della scheda SD su Fishino
#define SD_ChipSelectPin 4
#include <TMRpcm.h>
#include <SPI.h>

// l'oggetto audio player
TMRpcm tmrpcm;

void setup()
{
	// inizializza la porta seriale per il debug
	Serial.begin(115200);

	// imposta la porta a cui è connesso l'altoparlante
	// pin 9 per Fishino UNO o Guppy, 5, 6, 11 o 46 sul Mega
	tmrpcm.speakerPin = 9;

	if (!SD.begin(SD_ChipSelectPin))
	{
		Serial.println("Errore nella scheda SD");
		return;
	}
	
	// imposta la modalità loop (play ripetuto del brano)
	tmrpcm.loop(true);
	
	// riproduce il file audio 'nf.wav' sulla SD
	tmrpcm.play("nf.wav");
}

void loop()
{
}
