//////////////////////////////////////////////////////////////////////////
//		FishBook - Capitolo 8 - Scorrimento led con pulsanti			//
//	Spostiamo una scala luminosa avanti ed indietro con 2 pulsanti		//
//////////////////////////////////////////////////////////////////////////

int led;

void setup() {

  // imposta tutte le porte usate come uscite a livello basso
  for(int porta = 2; porta <= 9; porta++)
  {
    pinMode(porta, OUTPUT);
    digitalWrite(porta, LOW);
  }

  // disabilita il modulo WiFi
  pinMode(10, OUTPUT);
  digitalWrite(10, HIGH);

  // imposta le porte dei pulsanti come INPUT
  pinMode(11, INPUT);
  pinMode(12, INPUT);

  // iniziamo dal LED sulla porta D2
  led = 2;
  digitalWrite(led, HIGH);
}

void loop() {

  // è stato premuto il pulsante sulla porta 12 ?
  if(digitalRead(12) == HIGH)
  {
    // spegnamo il led acceso in precedenza
    digitalWrite(led, LOW);
    
    // spostiamo il led acceso a SINISTRA, aumentando il numero
    // contenuto nella variabile LED
    led++;

    // se il led è maggiore di 9 ricominciamo dall'uscita 2
    if(led > 9)
      led = 2;

     // accendiamo il nuovo led
     digitalWrite(led, HIGH);

     // piccolo ritardo per evitare i rimbalzi del pulsante
     // nel caso il pulsante sia di pessima qualità
     // è possibile aumentarlo
     delay(2);
     
     // attendiamo il rilascio del pulsante in modo che non
     // continuino a scorrere rapidamente i LED
     while(digitalRead(12) == HIGH)
        ;

     // il rimbalzo del pulsante può avvenire anche mentre
     // viene rilasciato; per sicurezza inseriamo anche qui
     // un piccolo ritardo
     delay(2);
  }

  // altrimenti è stato premuto il pulsante sulla porta 11 ?
  else if(digitalRead(11) == HIGH)
  {
    // spegnamo il led acceso in precedenza
    digitalWrite(led, LOW);
    
    // spostiamo il led acceso a DESTRA, diminuendo il numero
    // contenuto nella variabile LED
    led--;

    // se il led è minore di 2 ricominciamo dall'uscita 9
    if(led < 2)
      led = 9;

     // accendiamo il nuovo led
     digitalWrite(led, HIGH);

     // piccolo ritardo per evitare i rimbalzi del pulsante
     // nel caso il pulsante sia di pessima qualità
     // è possibile aumentarlo
     delay(2);
     
     // attendiamo il rilascio del pulsante in modo che non
     // continuino a scorrere rapidamente i LED
     while(digitalRead(11) == HIGH)
        ;

     // il rimbalzo del pulsante può avvenire anche mentre
     // viene rilasciato; per sicurezza inseriamo anche qui
     // un piccolo ritardo
     delay(2);
  }
}



