//////////////////////////////////////////////////////////////////////////
//		FishBook - Capitolo 9 - Variazione progressiva di luminosità	//
//	Facciamo variare progressivamente la luminosità di un led			//
//////////////////////////////////////////////////////////////////////////

// il tempo totale per un ciclo completo di luminosità
// in secondi e come numero reale per poter eseguire
// le operazioni con precisione
const double tempo = 2;

// il ritardo tra 2 cambi di luminosità è pari al tempo totale
// diviso 256 valori di luminosità e diviso 2 visto che vogliamo
// fare sia l'accensione che lo spegnimento graduali in sequenza
const unsigned t1 = (unsigned)(tempo * 1000 / 256 / 2);

void setup(void)
{
	// impostiamo la porta D3 come uscita
	pinMode(3, OUTPUT);
}

void loop(void)
{
	// ciclo di accensione
	for(int i = 0; i <= 255; i++)
	{
		analogWrite(3, i);
		delay(t1);
	}
	
	// ciclo di spegnimento
	for(int i = 255; i >= 0; i--)
	{
		analogWrite(3, i);
		delay(t1);
	}
}
