//////////////////////////////////////////////////////////////////////////
//		FishBook - Capitolo 9 - Variazione luminosità con PWM			//
//	Modifichiamo le liminosità di un LED tramite un potenziometro		//
//////////////////////////////////////////////////////////////////////////

void setup(void)
{
	// imposto la porta D3 come uscita
	pinMode(3, OUTPUT);
}

void loop(void)
{
	// leggo il valore del potenziometro sull'ingresso A0
	int pot = analogRead(0);
	
	// poichè analogRead() restituisce un valore tra 0 e 1023,
	// mentre l'analogWrite accetta un numero da 0 a 255
	// dobbiamo scalare la lettura del potenziometro
	pot /= 4;
	
	// scriviamo il nuovo valore di luminosità sulla porta D3
	analogWrite(3, pot);
}
