#ifndef _Archive_Archive_h
#define _Archive_Archive_h

#include <Core/Core.h>

using namespace Upp;

class Archive
{
	private:
	
		// archive path
		String _path;
		
		// error string
		String _errorMsg;
		
		// error flag
		bool _error;
		
		// copy data from one archive to another
		bool copyData(struct archive *ar, struct archive *aw);
	
	protected:
	
	public:
	
		// constructor
		Archive(String const &path);
		
		// destructor
		~Archive();
		
		// check if error state
		bool IsError(void) const { return _error; }
		
		// get error message
		String GetError(void) const { if(_error) return _errorMsg; else return ""; }
		
		// clear error state
		void ClearError(void) { _error = false; _errorMsg = ""; }
		
		// decompress archive into a given folder,
		// optionally stripping some elements parts
		bool Decompress(String const &destPath, int strip = 0);
		
		// progress function
		Event<int, int>Progress;
};

#endif
