#ifndef _FishIDE_Board_h_
#define _FishIDE_Board_h_

#include <Core/Core.h>

using namespace Upp;

class Package;
class Platform;

class Board
{
	friend class Package;
	friend class Platform;
	friend class PlatformVersion;

	public:
	
/*
		generic.menu.FlashSize.512K64=512K (64K SPIFFS)
		generic.menu.FlashSize.512K64.build.flash_size=512K
		generic.menu.FlashSize.512K64.build.flash_ld=eagle.flash.512k64.ld
		generic.menu.FlashSize.512K64.build.spiffs_start=0x6B000
		generic.menu.FlashSize.512K64.build.spiffs_end=0x7B000
		generic.menu.FlashSize.512K64.build.spiffs_blocksize=4096
		generic.menu.FlashSize.512K64.upload.maximum_size=434160
*/
		struct BoardMenuItem : Moveable<BoardMenuItem>
		{
			int _selectedItem;
			VectorMap<String, String> _descriptions;		// example : (512K64 "512K (64K SPIFFS)")...
			VectorMap<String, VectorMap<String, String> > _values;	// example : (512K64 (build.flash_size 512K)(build.flash_ld eagle.flash.512k64.ld)...
			String ToString(void) const { return String("_descriptions:") << _descriptions.ToString() << "\n_values:" << _values.ToString(); }
			
			BoardMenuItem() { _selectedItem = 0; }
		};

	private:
	
		// owning platform
		Platform *_platform;
	
		// board name
		String _name;
		
		// board description
		String _description;
		
		// arraymap of strings=value
		VectorMap<String, String> _values;
		
		// ArrayMap<MKEY, ArrayMap<MVAL, MVALDESK> >
		VectorMap<String, BoardMenuItem> _menuItems;
		
		// merged values (_values + _menuValues)
		// updated each time a board or a menu item gets selected
		// builders/uploaders take their values from here
		VectorMap<String, String> _mergedValues;
		
		// constructor
		Board(Platform *platform);
	
		// parse board data contained in a Value object
		bool ParseJSON(Value const &json);
		
		// parse a map containing boards file in form ok key=value
		bool ParseBoardsFile(VectorMap<String, String> const &map);
		
	protected:
	
	public:
	
		// destructor
		~Board();

		// owning platform
		Platform &GetPlatform(void) { return *_platform; }
		Platform const &GetPlatform(void) const { return *_platform; }
	
		// board name
		String const &GetName(void) const { return _name; }
		
		// board description
		String const &GetDescription(void) const { return _description; }
		
		// arraymap of strings=value
		VectorMap<String, String> const &GetValues(void) const { return _values; }
		
		// menu-selectable items
		VectorMap<String, BoardMenuItem> const &GetMenuItems(void) const { return _menuItems; }
		VectorMap<String, BoardMenuItem> &GetMenuItems(void) { return _menuItems; }
		
		// merge board fixed values with menu selected ones
		VectorMap<String, String>GetMergedValues(void) const;
		
		// get/set selectable items
		VectorMap<String, int> GetSelectedMenuItems(void) const;
		void SetSelectedMenuItems(VectorMap<String, int> const &items);
};

#endif
