#ifndef _FishIDE_BoardManage_h_
#define _FishIDE_BoardManage_h_

#include "Dialogs.h"
#include "Package.h"

class BoardManagerPane : public WithBoardManagerPaneLayout<StaticRect>
{
	typedef BoardManagerPane CLASSNAME;

	private:
	
		Platform &_platform;
		
		int _deltaHeight;
		
		// install/remove/update button handler
		void actionHandlerCb(void);
	
	protected:
	
	public:
	
		// constructor
		BoardManagerPane(Platform &platform);
		
		// destructor
		~BoardManagerPane();
		
		// get delta height (diff from pane and textbox heights)
		int GetDeltaHeight(void) const { return _deltaHeight; }
		
		// sets background color
		void BackColor(Upp::Color const &c);
	
		// fill pane from platform
		void FillPane(bool fillDrop);
};

class BoardManager : public WithBoardManagerLayout<TopWindow>
{
	typedef BoardManager CLASSNAME;
	
	private:
	
		Array<BoardManagerPane> _panes;
		
	protected:
	
		// adjust layout
		void Layout(void);
		
	public:
	
		// constructor
		BoardManager();
		
		// destructor
		~BoardManager();
	
		virtual void MouseWheel(Point, int zdelta, dword);
		bool Key(dword key, int);
		virtual void ChildMouseEvent(Ctrl *child, int event, Point p, int zdelta, dword keyflags);
};

#endif
