#ifndef _FishIDE_Dialogs_h_
#define _FishIDE_Dialogs_h_

#include <CtrlLib/CtrlLib.h>
#include <Controls4U/Controls4U.h>

#undef CR0
#undef CR1
#undef CR2

#define private public
#include <TabBar/TabBar.h>
#undef private

using namespace Upp;

#define LAYOUTFILE <FishIDE/FishIDE.lay>
#include <CtrlCore/lay.h>

/////////////////////////////////////////////////////////////////////////////////

class ProgressPopup : public WithIdeProgressLayout<TopWindow>
{
	private:
	
		bool _opened;
	
	protected:
	
	public:
	
		typedef ProgressPopup CLASSNAME;
	
		// constructor
		ProgressPopup(String const &title);
		
		// destructor
		~ProgressPopup();
		
		// show / hide me
		void Show(void);
		void Hide(void);
		
		// set progress
		void Set(int pos, int max);
		
		// return callback used to set progress
		Event<int, int>GetEventCb(void) { return THISBACK(Set); }
};

/////////////////////////////////////////////////////////////////////////////////

class CreateLibraryDialog : public WithCreateLibraryLayout<TopWindow>
{
	private:
	
	protected:
	
		// check dialog data
		bool Accept(void);
	
	public:
	
		typedef CreateLibraryDialog CLASSNAME;
		
		// constructor
		CreateLibraryDialog();
};

/////////////////////////////////////////////////////////////////////////////////

class AddLibraryDialog : public WithAddLibraryLayout<TopWindow>
{
	private:
	
	protected:
	
		// check dialog data
		bool Accept(void);
		
		// the column lists
		Array<ArrayCtrl> ctrls;
		
		// add and fill a list
		void AddList(String const &type, VectorMap<String, String> const &names);
	
	public:
	
		typedef AddLibraryDialog CLASSNAME;
		
		// constructor
		AddLibraryDialog();
		
		// gets selected library
		String GetLibrary(void);
};

/////////////////////////////////////////////////////////////////////////////////

class AddFilesDialog : public FileSel
{
	private:
	
	protected:
	
		// base path
		String _basePath;
		
		// library (or module) name
		String _libName;
	
		// entered files paths
		Vector<String> _paths;
		
		// error string, set by Check
		String _error;
		
		bool _checkExists;
		
	public:
	
		typedef AddFilesDialog CLASSNAME;
		
		// constructor
		AddFilesDialog(String const &basePath = "", String const &libName = "");
		
		void CheckExists(bool b) { _checkExists = b; }
		void NoCheckExists(void) { _checkExists = false; }
		
		// execute the dialog
		bool Run(void);

		// gets the full selected path
		Vector<String> const &GetPaths(void) const;
};

/////////////////////////////////////////////////////////////////////////////////

class RenameExampleDialog : public WithRenameExampleLayout<TopWindow>
{
	private:
	
	protected:
	
		bool Accept(void);
	
	public:
	
		// constructor
		RenameExampleDialog(String const &name);
	
		// destructor
		~RenameExampleDialog();
};

struct FindInFilesDlg : WithFindInFilesLayout<TopWindow>
{
	WString itext;

	virtual bool Key(dword key, int count);
	
	void Setup(bool replace);
	void Sync();

	typedef FindInFilesDlg CLASSNAME;
	
	FindInFilesDlg();
};

#endif
