#ifndef _FishIDE_ExampleManager_h_
#define _FishIDE_ExampleManager_h_

#include "Dialogs.h"
#include "Examples.h"

class ExampleManagerPane : public WithExampleManagerPaneLayout<StaticRect>
{
	typedef ExampleManagerPane CLASSNAME;

	private:
	
		Example &_example;
	
		int _deltaHeight;
		
		// install/remove/update button handler
		void actionHandlerCb(void);
	
	protected:
	
	public:
	
		// constructor
		ExampleManagerPane(Example &example);
		
		// destructor
		~ExampleManagerPane();
		
		// get delta height (diff from pane and textbox heights)
		int GetDeltaHeight(void) const { return _deltaHeight; }
		
		// sets background color
		void BackColor(Upp::Color const &c);
	
		// fill pane from platform
		void FillPane(bool fillDrop);
		
		Example const &GetExample(void) const { return _example; }
		
		// action event
		Event<> WhenAction;
};

class ExampleManager : public WithExampleManagerLayout<TopWindow>
{
	typedef ExampleManager CLASSNAME;
	
	private:
	
		// the panes
		Array<ExampleManagerPane> _panes;
		
		// modified flag
		bool _modified;
		
		// filter pane by current filters
		bool FilterPane(ExampleManagerPane &pane);
		
	protected:
	
		// action handler
		void actionCb(void);

		// adjust layout
		void Layout(void);
		
	public:
	
		// constructor
		ExampleManager();
		
		// destructor
		~ExampleManager();
	
		virtual void MouseWheel(Point, int zdelta, dword);
		bool Key(dword key, int);
		virtual void ChildMouseEvent(Ctrl *child, int event, Point p, int zdelta, dword keyflags);
		
		// action event
		Event<> WhenChange;
};

#endif
