#ifndef _FishIDE_FileFinder_h_
#define _FishIDE_FileFinder_h_

#include "Dialogs.h"
#include "FishIDEEditor.h"

class Project;
class FileFinderClass
{
	friend FileFinderClass &__GetFileFinder();
	
	private:
		enum { STYLE_NO_REPLACE, STYLE_CONFIRM_REPLACE, STYLE_AUTO_REPLACE };

		struct ErrorInfo {
			String file;
			int    lineno;
			int    linepos;
			int    len;
			int    kind;
			String message;
			String error_pos;
			
			ErrorInfo() { lineno = linepos = kind = len = 0; }
		};
	
		struct FileData {
			Time               filetime;
			LineEdit::EditPos  editpos;
			Point              columnline;
			LineEdit::UndoData undodata;
			LineInfo           lineinfo;
			LineInfoRem        lineinforem;
	
			void Clear()  {
				filetime = Null; editpos.Clear(); undodata.Clear();
				columnline = Null; lineinfo.Clear(); lineinforem.Clear();
			}
			void ClearP() {
				lineinforem.Clear();
				undodata.Clear();
			}
		};

		Project *proj;
	
		FileSel sSD;
		FindInFilesDlg ff;
		String iwc;
		
		ArrayMap<String, FileData> filedata;

		FileFinderClass();
	
		void AddFoundFile(const String& fn, int ln, const String& line, int pos, int count);
		void Renumber(void);
		bool SearchInFile(const String& fn, const String& pattern, bool wholeword, bool ignorecase, int& n, RegExp *regexp, int style);
		void FindFileAll(const Vector < Tuple < int, int >> & f);
		void FindString(bool back);
		void InsertWildcard(const char *s);
		void FindWildcard();
		void FindSetStdDir(String n);
		void FindStdDir();
		void FindFolder();
		void SyncFindInFiles();
		void ConstructFindInFiles();
		
	protected:
	
	public:
	
		typedef FileFinderClass CLASSNAME;
	
		~FileFinderClass();
	
		void Xmlize(XmlIO &xml);

		void FindInFiles(Project *project, bool replace);
};

extern FileFinderClass &__GetFileFinder();

#define FileFinder __GetFileFinder()

#endif
