#include "FileInfo.h"

#include "Project.h"
#include "FishIDEEditor.h"

// constructor
FileInfo::FileInfo(String const &path, Project *owner) : _owner(owner)
{
	_ideFile = IdeFilePool.GetIdeFile(this, path);
//	_cursor = 0;
	_editPos.Clear();
}

// destructor
FileInfo::~FileInfo()
{
	if(_ideFile)
		IdeFilePool.ReleaseIdeFile(this, _ideFile);
}

// reload handler -- triggered by IdeFile when reloading
void FileInfo::Reloaded(void)
{
	// check if we shall reload inside editor
	if(FishIDEEditor.GetFileInfo() == this)
		FishIDEEditor.reloadCb();
	_undoData.Clear();
}

// save
bool FileInfo::Save(void)
{
	if(_ideFile)
		return _ideFile->Save();
	
	return false;
}

bool FileInfo::SaveAs(String const &newPath)
{
	if(_ideFile)
	{
		String path = _ideFile->GetPath();
		String s = _ideFile->Get();
		IdeFilePool.ReleaseIdeFile(this, _ideFile);
		_ideFile = IdeFilePool.GetIdeFile(this, newPath);
		if(!_ideFile)
			return false;
		_ideFile->Set(s);
		_ideFile->Save();
		return true;
	}
	return false;
}

// reload the file
bool FileInfo::Reload(void)
{
	if(!_ideFile)
		return false;
	return _ideFile->Reload();
}
