#ifndef _FishIDE_FileInfo_h_
#define _FishIDE_FileInfo_h_

#include "IdeFilePool.h"
#include <CtrlLib/CtrlLib.h>

class Project;
class FileInfo : public Pte<FileInfo>
{
	friend class IdeFile;
	
	private:

		// associated editor object
		IdeFile *_ideFile;
		
		// saved editor cursor position
//		int _cursor;
		LineEdit::EditPos _editPos;
		
		// undo data for current file
		TextCtrl::UndoData _undoData;
		
		// owner project
		Project *_owner;
		
		// reload handler -- triggered by IdeFile when reloading
		void Reloaded(void);
		
	protected:
	
	public:
		
		// constructor
		FileInfo(String const &path, Project *owner);
		
		// destructor
		~FileInfo();
		
		// check for validity
		operator bool() { return _ideFile != NULL; }
		bool operator!() { return _ideFile == NULL; }
		
		// save
		bool Save(void);
		bool SaveAs(String const &newPath);
		
		// get path
		String GetPath(void) const { return _ideFile->GetPath(); }
		
		// get/set cursor
/*
		int GetCursor(void) const { return _cursor; }
		void SetCursor(int c) { _cursor = c; }
*/
		LineEdit::EditPos GetEditPos(void) const { return _editPos; }
		void SetEditPos(LineEdit::EditPos const &pos) { _editPos = pos; }
		
		LineEdit::UndoData GetUndoData(void) { return pick(_undoData); }
		void SetUndoData(LineEdit::UndoData &&data) { _undoData = pick(data); }
		
		// get the editor
		IdeFile *GetIdeFile(void) { return _ideFile; }
		
		// get/set file content
		String const &Get(void) const { if(_ideFile) return _ideFile->Get(); else { static String s; return s; } }
		void Set(String const &s) { if(_ideFile) _ideFile->Set(s); }
		
		// check if file is read only
		bool IsReadOnly(void) const { if(!_ideFile) return true; return _ideFile->IsReadOnly(); }
		
		// set readonly flag
		void SetReadOnly(bool b = true) { if(!_ideFile) return; _ideFile->SetReadOnly(b); }
		void SetNoReadOnly(void) { SetReadOnly(false); }

		// check if file has been modified
		bool IsModified(void) const { if(!_ideFile) return false; return _ideFile->IsModified(); }
		
		// set modified flag
		void SetModified(void) { if(_ideFile) _ideFile->SetModified(); }
		
		// get project
		Project *GetProject(void) { return _owner; }
		
		// reload the file
		bool Reload(void);
};
			
#endif
