#ifndef _TheArduIDE_FileTools_h_
#define _TheArduIDE_FileTools_h_

#include <Core/Core.h>

using namespace Upp;

class FileTools
{
	private:
	
	protected:
	
	public:
		
		// scan a folder for files or folders
		static Vector<String> ScanFolder(String const &path, String const &pattern, bool folders);
				
		// scan a folder for files
		static Vector<String> ScanFolder(String const &path, Vector<String> const &patterns);
				
		// recurse scan a folder for files
		static Vector<String>RecurseScan(String const &path, String const &pattern, String const &sub = "");

		// recurse scan a folder for files
		static Vector<String>RecurseScan(String const &path, Vector<String> const &patterns);

		// check if file/folder is writeable
		static bool IsReadOnly(String const &path);
		
		// unpacks an archive on a destination folder
		// a-la-arduino :
		// 1) archive MUST contain a single folder
		// 2) root folder name is replaced by given last folder in dest path
		static bool UnpackArduinoArchive(String const &archivePath, String const &destPath, Event<int, int>progress = Event<int, int>());

		// same with progress popup
		static bool UnpackArduinoArchive(String const &prompt, String const &archivePath, String const &destPath);

		// delete folders deep - patched for links
		static bool DeleteFolderDeep(const char *dir);
		
		// read a value file into a map of key=value pairs
		static VectorMap<String, String> ReadValueFile(String const &path);
		
		// copy a directory to a new destination
		// both source and dest MUST be folder paths
		static bool DirectoryCopy(String const &sourcePath, String const &destPath);
};

#endif
