#ifndef _FishIDE_FishIDEEditor_h_
#define _FishIDE_FishIDEEditor_h_

#include <CodeEditor/CodeEditor.h>
#include "ImageView.h"
#include "HexView.h"

#include "FileInfo.h"

enum class EditorKind
{
	NONE = 0,
	CODE = 1,
	TEXT = 2,
	IMAGE = 3,
	BINARY = 4
};
		
class FishIDEEditorClass : public ParentCtrl
{
	friend class FileInfo;
	
	public:
	
	private:
	
		// editor kind
		EditorKind _kind;
		
		// the embedded code editor
		CodeEditor _codeEditor;
		
		// the embedded image viewer
		ImageView _imageView;
		
		// the embedded hex viewer
		HexViewCtrl _hexView;
	
		// the file being displayed in editor
		Ptr<FileInfo> _editorFile;
		
		// do not allow copy
		FishIDEEditorClass(FishIDEEditorClass const &f) {}
		
		// setup code editor defaults
		void SetupCodeEditor(void);
		
		// get current file info
		FileInfo *GetFileInfo(void) { return _editorFile; }
		
		// reload code into editor
		// internal function called by FileInfo object
		void reloadCb(void);
		
	protected:
	
		// check/replace child control
		void SetChild(Ctrl *newChild);
	
		// detect changes in editor
		void changeCb(void);
	
	public:
	
		// constructor
		FishIDEEditorClass();
		
		// destructor
		~FishIDEEditorClass();
		
		String GetPath();
		
		// from codeeditor
		
		bool IsReadOnly(void);
		void SetReadOnly(bool b);
		
		bool IsSelection() const;
		bool GetSelection(int& l, int& h) const;
		WString GetSelectionW() const;
		void SetSelection(int anchor = 0, int cursor = INT_MAX);
		void SelectAll();

		WString GetW() const;
		WString GetI();
		String  Get(byte charset = CHARSET_DEFAULT) const;
		void Set(const WString& s);
		void Set(const String& s, byte charset = CHARSET_DEFAULT);

		int GetLength() const;
		int GetIndexLinePos(Point pos) const;

		int GetCursor() const;
		void SetCursor(int cursor);
		void CenterCursor();
		
		LineEdit::EditPos GetEditPos(void) const;
		void SetEditPos(LineEdit::EditPos const &pos);

		LineEdit::UndoData GetUndoData(void);
		void SetUndoData(LineEdit::UndoData &&data);
		void ClearUndoData(void);

		void Remove(int pos, int size);
		int Insert(int pos, const WString& txt);

		void Cut();
		void Copy();
		void Paste();
		void Undo();
		void Redo();
		bool IsUndo() const;
		bool IsRedo() const;
		void NextUndo();
		
/*
		bool IsDirty() const;
		bool IsModified() const;
		void ClearDirty();
		void ClearEdited();
*/

		bool Find(bool back, bool block);
		void FindReplace(bool pick_selection, bool pick_text, bool replace);
		void FindNext();
		void FindPrev();
		bool FindString(bool back);
		
		int BlockReplace();
		CodeEditor::FindReplaceData GetFindReplaceData();
		void SetFindReplaceData(const CodeEditor::FindReplaceData& d);
		void Renumber(void);
		
		void CachePos(int pos);
		int GetLinePos(int& pos) const;
		WString GetWLine(int i) const;
		void PutI(WithDropChoice<EditString>& edit);

		// flush the editor onto belonging FileInfo object
		void Flush(void);
		
		// assign the editor to an IdeFile object
		void Assign(FileInfo *fileInfo);
		
		// reload the file into editor
		void Reload(void);
		
		// sets the focus to contained child
		void SetFocus(void);
		
		// get editor's kind
		EditorKind GetKind(void) const { return _kind; }
	
		// style the editor based on settings
		void StyleEditor(Theme const *theme = NULL);

		typedef FishIDEEditorClass CLASSNAME;
};

#define FishIDEEditor __GetFishIDEEditor()

FishIDEEditorClass &__GetFishIDEEditor();


#endif
