#include "Hex.h"

void Hex::ScanHex(String const &ss)
{
	String s = ToLower(ss);
	const char *c = ~s;
	if(s.StartsWith("0x"))
		c += 2;
	val = 0;
	while(*c && IsXDigit(*c))
	{
		val *= 16;
		if(*c >= '0' && *c <= '9')
			val += *c - '0';
		else
			val += 10 + *c - 'a';
		c++;
	}
}

void Hex2::Xmlize(XmlIO &xml)
{
	if(xml.IsLoading())
	{
		String s;
		::Xmlize(xml, s);
		ScanHex(s);
	}
	else
	{
		String s = Format("0x%02x", val);
		::Xmlize(xml, s);
	}
}

void Hex4::Xmlize(XmlIO &xml)
{
	if(xml.IsLoading())
	{
		String s;
		::Xmlize(xml, s);
		ScanHex(s);
	}
	else
	{
		String s = Format("0x%04x", val);
		::Xmlize(xml, s);
	}
}