#ifndef _FishIDE_Hex_h_
#define _FishIDE_Hex_h_

#include <Core/Core.h>

using namespace Upp;

// a couple of helpers to have hex values correctly xmlized
class Hex
{
	protected:
		unsigned short val;
		
	public:
		
		Hex()							{ val = 0; }
		Hex(unsigned i)					{ val = i; }
		Hex(int i)						{ val = i; }
		operator unsigned(void) const	{ return val; }
		operator int(void) const		{ return val; }
		operator bool(void) const		{ return val != 0; }
		bool operator !(void) const		{ return val == 0; }
		Hex& operator=(unsigned i)		{ val = i; return *this; }
		Hex& operator=(int i)			{ val = i; return *this; }
	
		void ScanHex(String const &s);
		virtual void Xmlize(XmlIO &xml) = 0;
};

class Hex2 : public Hex
{
	public:
	
		Hex2() : Hex()					{}
		Hex2(unsigned i) : Hex(i)		{}
		Hex2(int i) : Hex(i)			{}

		Hex& operator=(unsigned i)		{ val = i; return *this; }
		Hex& operator=(int i)			{ val = i; return *this; }

		virtual void Xmlize(XmlIO &xml);
};

class Hex4 : public Hex
{
	public:
	
		Hex4() : Hex()					{}
		Hex4(unsigned i) : Hex(i)		{}
		Hex4(int i) : Hex(i)			{}

		Hex& operator=(unsigned i)		{ val = i; return *this; }
		Hex& operator=(int i)			{ val = i; return *this; }

		virtual void Xmlize(XmlIO &xml);
};

#endif
