#include "HexView.h"

int64 HexViewCtrl::Key() const
{
	return _blk;
}

int HexViewCtrl::Make(String& object) const
{
	if(!_data)
		return 0;
	object = (*_data).Mid(_blk * HexViewCtrl::BLKSIZE, HexViewCtrl::BLKSIZE);
	return 1;
}

int HexViewCtrl::Byte(int64 addr)
{
	_blk = addr >> BLKSHIFT;
	String h = _cache.Get(*this);
	_cache.Shrink(10); // cache only 10 blocks (~150 KB)
	int ii = addr & (BLKSIZE - 1);
	return ii < h.GetCount() ? (byte)h[ii] : 0;
}

void HexViewCtrl::Set(const String &data)
{
	_data = &data;
	SetTotal(data.GetCount());
	_cache.Clear();
}

HexViewCtrl::HexViewCtrl()
{
	InfoMode(2);
	LoadFromGlobal(*this, "FileHexView");
	_data = NULL;
	_blk = 0;
}

HexViewCtrl::~HexViewCtrl()
{
	StoreToGlobal(*this, "FileHexView");
}

INITIALIZER(HexViewCtrl)
{
	RegisterGlobalConfig("FileHexView");
}
