#ifndef _FishIDE_HexView_h_
#define _FishIDE_HexView_h_

#include <HexView/HexView.h>

using namespace Upp;

class HexViewCtrl : public HexView, private LRUCache<String, int64>::Maker
{
	public:
		virtual int Byte(int64 addr);

		virtual int64 Key() const;
		virtual int Make(String& object) const;

		virtual void   EditMenu(Bar& menu)
		{
			StdMenu(menu);
		}

	private:
	
		String const *_data;
		int64 _blk;
		

		LRUCache<String, int64> _cache;

		enum { BLKSHIFT = 14, BLKSIZE = 1 << BLKSHIFT };


	public:
		void Serialize(Stream& s)
		{
			SerializeSettings(s);
		}

		void Set(String const &data);

		HexViewCtrl();
		~HexViewCtrl();
};


#endif
