#ifndef _FishIDE_IdeEnvironment_h_
#define _FishIDE_IdeEnvironment_h_

#include "Package.h"
#include "ProcTools.h"

class Project;

/*
{runtime.platform.path}     - the absolute path of the platform folder (i.e. the folder containing boards.txt)    
{runtime.hardware.path}     - the absolute path of the hardware folder (i.e. the folder containing the current platform folder)    
{runtime.ide.path}          - the absolute path of the Arduino IDE folder     
{runtime.ide.version}       - the version number of the Arduino IDE as a number (for example "152" for Arduino IDE 1.5.2)     
{runtime.os}                - the running OS ("linux", "windows", "macosx")      

{build.path}              - The path to the temporary folder to store build artifacts
{build.project_name}      - The project name
{build.arch}              - The MCU architecture (avr, sam, etc...)

{ide_version}              - the IDE version (ex. "152" for Arduino IDE 1.5.2)
{includes}                 - the list of include paths in the format "-I/include/path -I/another/path...."
{source_file}              - the path to the source file
{object_file}              - the path to the output file

{ide_version}              - the IDE version (ex. "152" for Arduino IDE 1.5.2)
{object_file}              - the object file to include in the archive
{archive_file}             - the name of the resulting archive (ex. "core.a")

{ide_version}              - the IDE version (ex. "152" for Arduino IDE 1.5.2)
{object_files}             - the list of object files to include in the archive ("file1.o file2.o ....")
{archive_file}             - the name of the core archive file (ex. "core.a")

{build.variant.path}

{runtime.tools.TOOL_NAME.path}
{runtime.tools.TOOL_NAME-TOOL_VERSION.path} 

{tools.TOOL_ID.ACTION.params.verbose}		{tools.avrdude.upload.params.verbose=-v -v -v -v}
{tools.TOOL_ID.ACTION.params.quiet}			{tools.avrdude.upload.params.quiet=-q -q}
{ACTION.verbose}							{upload.verbose}

{tools.avrdude.cmd.path} == {cmd.path}

myboard.build.core=arduino:arduino
                    vendor  core

myboard.build.variant=arduino:standard
                       vendor  variant

myboard.upload.tool=arduino:avrdude
                    vendor   tool

*/

class IdeEnvironment
{
	private:
	
	protected:
	
		// currente project
		Project *_project;
		
		// current board, platform and platform version
		Board *_board;
		Platform *_platform;
		PlatformVersion *_version;
		
		// environment variables
		VectorMap<String, String> _variables;
		
		// process tolls needed to run commands
		ProcTools _procTools;
		
		// patterns for source file scans
		Vector<String> _sourcesPattern;
		Vector<String> _includesPattern;
		Vector<String> _objectsPattern;
		
		// current architecture
		String _architecture;
		
		// platform root path
		String _platformRoot;
		
		// platform libraries path
		String _platformLibsRoot;
		
		// user libraries path
		String _userLibsRoot;
		
		// core to build
		String _core;
		String _coreRoot;
		
		// variant to build
		String _variant;
		String _variantRoot;
		
		// build root path
		String _buildPath;
		
		// full rebuild flag
		bool _fullRebuild;
		
		// verbosity levels
		int _compilerVerbosity;
		int _uploaderVerbosity;
		
		// warning level
		int _compilerWarningLevel;
		String _compilerUserWarnings;

		// optimization level
		int _compilerOptimizations;
		
	public:
	
		// constructor
		IdeEnvironment();
		
		// destructor
		~IdeEnvironment();
		
		// setup environment for build/upload
		bool Setup(Project *project);
	
};

#endif
