#ifndef _FishIDE_EditorPool_h_
#define _FishIDE_EditorPool_h_

#include "Theme.h"

using namespace Upp;

class FileInfo;
class IdeFile
{
	friend class IdeFilePoolClass;
	
	private:
		// usage reference count
		Index<Ptr<FileInfo>> _references;
		
		// file path on media
		String _path;
		
		// error flag
		bool _error;
		
		// modified flag
		bool _modified;
		
		// read only flag
		bool _readOnly;
		
		// file content
		String _content;
		
		// file last save/opened time
		// uset to check if something has changed on disk
		FileTime _fileTime;
		
	protected:
	
	public:
	
		typedef IdeFile CLASSNAME;

		// constructor
		IdeFile(String const &path);
		
		// destructor
		~IdeFile();
		
		// get path
		String const &GetPath(void) const { return _path; }
		
		// check if modified
		bool IsModified(void) const { return _modified; }
		
		// set as modified
		void SetModified(void) { _modified = true; }
		
		// add-remove reference
		int AddRef(Ptr<FileInfo> owner);
		int RemRef(Ptr<FileInfo> owner);
		
		// save file
		bool SaveAs(String const &path);
		bool Save(void);
		
		// get editor content
		String const &Get(void) const { return _content; }

		// set/update content
		void Set(String const &s);
		
		// reload content from disk
		// and signals event to attached FileInfos
		bool Reload(void);
		
		// check if file has been changed on disk since last save
		bool CheckFileChanges(void);

		// rename
		bool Rename(String const &newName);
		
		// check error flag
		bool IsError(void) { return _error; }
		
		// check readonly flag
		bool IsReadOnly(void) const { return _readOnly; }
		
		// set readonly flag
		void SetReadOnly(bool b = true) { _readOnly = b; }
};

class IdeFilePoolClass
{
	friend IdeFilePoolClass &__GetIdeFilePool(void);
	private:
	
		// array of handled CodeEditor objects
		Array<IdeFile> _ideFiles;
		
		// constructor
		IdeFilePoolClass();
		
	protected:
	
	public:
	
		// destructor
		~IdeFilePoolClass();
		
		// get an editor from pool, or load/create it if not there
		IdeFile *GetIdeFile(Ptr<FileInfo> owner, String const &path);
		
		// releases an editor
		void ReleaseIdeFile(Ptr<FileInfo> owner, IdeFile *editor);
		
		// check if a path is opened inside pool
		bool IsOpened(String const &path) const;
		
		// save all codeeditors in pool
		void SaveAll(void);
		
		// get the number of files inside pool
		int GetCount(void) const { return _ideFiles.GetCount(); }
		
		// get an array with all paths inside pool
		Vector<String> GetPaths(void) const;
};

IdeFilePoolClass &__GetIdeFilePool(void);

#define IdeFilePool __GetIdeFilePool()

#endif
