#ifndef _FishIDE_LibraryInfo_h_
#define _FishIDE_LibraryInfo_h_

#include "AVersion.h"

class LibraryInfo : Moveable<LibraryInfo>, public Pte<LibraryInfo>
{
	public:
		enum Kind
		{
			PLATFORM = 0,
			SYSTEM = 1,
			USER = 2
		};
	
	private:
	
		// library root path
		String _path;
		
		// kind of library
		Kind _kind;
		
		// library properties
		bool _oldStyle;
		bool _anyArchitecture;
		String _name;
		AVersion _version;
		String _author;
		String _maintainer;
		String _sentence;
		String _paragraph;
		String _category;
		String _url;
		Vector<String>_architectures;
		Vector<String>_includes;
		
		// clear info data
		void ClearInfo(void);
		
		// read properties file
		void ReadPropertiesFile(void);
		
		// library files
		Vector<String> _files;
		
	protected:
	
	public:
	
		// constructors
		LibraryInfo(String pth);
		LibraryInfo(void);
		
		// pick copy constructors
		LibraryInfo(LibraryInfo &&lib) = default;
		LibraryInfo &operator=(LibraryInfo &&lib) = default;
		
		// destructor
		~LibraryInfo();
		
		// check if empty
		bool IsEmpty(void) const { return _path.IsEmpty(); }
		
		// check if old style
		bool IsOldStyle(void) const { return _oldStyle; }
	
		// check if architecture is supported by lib
		bool SupportsArchitecture(String const &arc) const;
		bool SupportsAnyArchitecture(void) const { return _anyArchitecture; }
		
		// some getters
		String const &GetPath(void) const		{ return _path; }
		String const &GetName(void) const		{ return _name; }
		AVersion const &GetVersion(void) const	{ return _version; }
		String const &GetAuthor(void) const		{ return _author; }
		String const &GetMaintainer(void) const	{ return _maintainer; }
		String const &GetSentence(void) const	{ return _sentence; }
		String const &GetParagraph(void) const	{ return _paragraph; }
		String const &GetCathegory(void) const	{ return _category; }
		String const &GetUrl(void) const		{ return _url; }
		
		Vector<String> const &GetArchitectures(void) const { return _architectures; }
		void SetArchitectures(Vector<String> const &archs) { _architectures = Vector<String>(archs, 1); _anyArchitecture = (archs.GetCount() == 1 && archs[0] == "*"); }
		
		Vector<String> const &GetIncludes(void) const { return _includes; }
		void SetIncludes(Vector<String> const &includes) { _includes <<= includes; }
		
		// get include path
		String GetIncludePath(void) const;
		
		// get sources root
		String GetSourcesRoot(void) const { return GetIncludePath(); }

		// get include files
		Vector<String> ScanIncludes(bool fullPath) const;
		
		// get source files
		Vector<String> ScanSources(bool fullPath) const;
		
		// files order management
		// used when showing files on IDE
		Vector<String> const &ScanFiles(Vector<String> const &files = Vector<String>());
		
		// const version -- just return previously scanned files
		Vector<String> const &GetFiles(void) { if(_files.IsEmpty()) ScanFiles(); return _files; }
		
		// get/set Kind
		Kind GetKind(void) const { return _kind; }
		void SetKind(Kind kind) { _kind = kind; }
		
		String ToString(void) const { return _name + ":" + _path; }
};

#endif
