#ifndef _FishIDE_LibraryManager_h_
#define _FishIDE_LibraryManager_h_

#include "Dialogs.h"
#include "Libraries.h"

class LibraryManagerPane : public WithLibraryManagerPaneLayout<StaticRect>
{
	typedef LibraryManagerPane CLASSNAME;

	private:
	
		Library &_library;
	
		int _deltaHeight;
		
		// install/remove/update button handler
		void actionHandlerCb(void);
	
	protected:
	
	public:
	
		// constructor
		LibraryManagerPane(Library &library);
		
		// destructor
		~LibraryManagerPane();
		
		// get delta height (diff from pane and textbox heights)
		int GetDeltaHeight(void) const { return _deltaHeight; }
		
		// sets background color
		void BackColor(Upp::Color const &c);
	
		// fill pane from platform
		void FillPane(bool fillDrop);
		
		Library const &GetLibrary(void) const { return _library; }
		
		// action event
		Event<> WhenAction;
};

class LibraryManager : public WithLibraryManagerLayout<TopWindow>
{
	typedef LibraryManager CLASSNAME;
	
	private:
	
		// the panes
		Array<LibraryManagerPane> _panes;
		
		// modified flag
		bool _modified;
		
		// filter pane by current filters
		bool FilterPane(LibraryManagerPane &pane);
		
	protected:
	
		// action handler
		void actionCb(void);

		// adjust layout
		void Layout(void);
		
	public:
	
		// constructor
		LibraryManager();
		
		// destructor
		~LibraryManager();
	
		virtual void MouseWheel(Point, int zdelta, dword);
		bool Key(dword key, int);
		virtual void ChildMouseEvent(Ctrl *child, int event, Point p, int zdelta, dword keyflags);
		
		// action event
		Event<> WhenChange;
};

#endif
