#ifndef _FishIDE_LibraryPool_h_
#define _FishIDE_LibraryPool_h_

#include "LibraryInfo.h"

class LibraryPoolClass
{
	friend LibraryPoolClass &__GetLibraryPool();
	
	private:
	
		// scanned libraries
		Array<LibraryInfo> _libraries;
		
		// map includes to libraries
		// first map is by architecture, second by include name
		// first architecture in map is "*", meaning any architecture
		ArrayMap<String, ArrayMap<String, int> >_includeMap;
		
		// map names to libraries
		// first map is by architecture, second by include name
		// first architecture in map is "*", meaning any architecture
		ArrayMap<String, ArrayMap<String, int> >_nameMap;
		
		// constructor
		LibraryPoolClass();
		
		// scan a folder for libraries
		bool ScanFolder(String const &path, LibraryInfo::Kind kind);
		
		// build first-level dependencies for a library
		Vector<Ptr<LibraryInfo>> LibraryDependencies(Ptr<LibraryInfo> const &lib, String const &architecture);
		
	protected:
	
	public:
	
		// destructor
		~LibraryPoolClass();
		
		// rescan all available libraries
		bool Scan(void);
		
		// find a library by include file and architecture name name
		Ptr<LibraryInfo> FindByInclude(String const &include, String const &architecture);
		
		// find a group of libraries by a group of includes
		Vector<Ptr<LibraryInfo>> FindByIncludes(Vector<String> const &includes, String const &architecture);
		
		// find a library by name and architecture name
		LibraryInfo *FindByName(String const &name, String const &architecture);
	
		// find a group of libraries by names and architecture name
		Vector<Ptr<LibraryInfo>> FindByNames(Vector<String> const &names, String const &architecture);
		
		// get library names
		Vector<String> GetNames(LibraryInfo::Kind kind) const;

		// get library names and descriptions
		VectorMap<String, String> GetNamesDescs(LibraryInfo::Kind kind) const;
		
		// given a list of libraries, add to it dependent ones
		Vector<Ptr<LibraryInfo>> SolveDependencies(Vector<Ptr<LibraryInfo>> const &libs, String const &architecture);

};

extern LibraryPoolClass &__GetLibraryPool(void);

#define LibraryPool __GetLibraryPool()

#endif
