#ifndef _FishIDE_Package_h_
#define _FishIDE_Package_h_

#include "Platform.h"
#include "Tool.h"

class Package
{
	friend class PackagesClass;

	private:
	
		// package name
		String _name;
		
		// maintainer
		String _maintainer;
		
		// website url
		String _websiteURL;
		
		// email
		String _email;
		
		// help URLs
		ArrayMap<String, String> _helpURLs;
		
		// the provided platforms
		Array<Platform> _platforms;
		
		// the provided tools
		Array<Tool> _tools;
		
		// parse package data contained in a Value object
		bool ParseJSON(Value const &json);
		
	protected:
	
	public:
	
		// constructor
		Package();
		
		// destructor
		~Package();
	
		// get package name
		String const &GetName(void) const { return _name; }
		
		// maintainer
		String const &GetMaintainer(void) const { return _maintainer; }
		
		// website url
		String const &GetWebsiteURL(void) const { return _websiteURL; }
		
		// email
		String const &GetEMail(void) const { return _email; }
		
		// help URLs
		ArrayMap<String, String> const &GetHelpURLs(void) const { return _helpURLs; }
		
		// the provided platforms
		Array<Platform> const &GetPlatforms(void) const { return _platforms; }
		Array<Platform> &GetPlatforms(void) { return _platforms; }
		
		// the provided tools
		Array<Tool>  const &GetTools(void) const { return _tools; }
		Array<Tool>  &GetTools(void) { return _tools; }
		
		// find a platform by name
		Platform const *FindPlatform(String const &name) const;
		Platform *FindPlatform(String const &name);
		
		// find a tool by name
		Tool const *FindTool(String const &name, String const &version) const;
		Tool *FindTool(String const &name, String const &version);
		
		// find a platform by architecture
		Platform *FindPlatformByArchitecture(String const &arch);
		Platform const *FindPlatformByArchitecture(String const &arch) const;
};

class PackagesClass : public Array<Package>
{
	friend PackagesClass &__GetPackages(void);
	
	private:
	
		// constructor
		PackagesClass();
	
	protected:
	
	public:
	
		// destructor
		~PackagesClass();
		
		// clear
		PackagesClass &Clear(void);

		// parse package json data
		bool ParseJSON(String const &s);
		
/*
		// find a platform by name
		Platform const *FindPlatform(String const &name) const;
		Platform *FindPlatform(String const &name);
		
		// find a tool by name
		Tool const *FindTool(String const &name, String const &version) const;
		Tool *FindTool(String const &name, String const &version);
*/
		
		// find a package by name
		Package const *FindPackage(String const &name) const;
		Package *FindPackage(String const &name);

		// cleanup unused tools
		bool CleanupTools(void);
};

extern PackagesClass &__GetPackages(void);

#define Packages __GetPackages()

#endif
