#ifndef _FishIDE_ProcTools_h_
#define _FishIDE_ProcTools_h_

#include <Core/Core.h>

using namespace Upp;

class ProcTools
{
	private:
	
		Vector<String> ParseArgLine(String const &argLine);
		
		LocalProcess _proc;

		String _out, _err;
	
	protected:
	
	public:
	
		typedef ProcTools CLASSNAME;
		
		ProcTools();
		
		ProcTools &Clear(void);
	
		bool Exec(String const &cmd, String const &argLine);
		bool Exec(String const &cmdLine);
		
		Function<bool(String)> WhenOutput;
		Function<bool(String, String)> WhenOutErr;
		
		String const &GetOutput(void) const { return _out; }
		String const &GetError(void) const { return _err; }
	
};

#endif
