#ifndef _FishIDE_ProjectsCtrl_h_
#define _FishIDE_ProjectsCtrl_h_

#undef CR0
#undef CR1
#undef CR2
#include <TabBar/TabBar.h>

#include "Project.h"

class ProjectsCtrl : public TabBarCtrl
{
	private:
	
		// opened projects
		Array<Project> projects;
		
		// projects splitters positions
		// kept in sync between opened projects
		// and stored on file upon exit
		int hSplitter, vSplitter, flSplitter;
		
	protected:
	
		// finds project index in array
		int FindProjectIndex(Project *proj) const;
		
		// finds project tab
		int FindProjectTab(Project *proj);
	
		// remove control when closing tab
		bool closeTabCb(Value tab);

		// detect some changes in tabs
		void changeCb(void);
	
		// check if project exists
		bool CheckExist(String const &path) const;
		
		// check if project already opened
		bool CheckOpened(String const &path) const;
		
		// projects splitters handling
		void splitterCb(int h, int v, int fl);
		
		// deleting file event handler
		// forward file close to all projects
		void deletingFileCb(String const &path);
		
		// setup code editor defaults
		void SetupCodeEditor(void);
				
		// style an editor based on settings
		void StyleEditor(Theme const *theme = NULL);

	public:
	
		typedef ProjectsCtrl CLASSNAME;
		
		// constructor
		ProjectsCtrl();

		// destructor
		~ProjectsCtrl();

		// new empty project
		bool NewProject(String const &path, bool createDefault = true);
		
		// open existing project
		bool OpenProject(String path);
		
		// import arduino project
		bool ImportProject(String const &arduPath, String const &path);
		
		// remove current project
		bool RemoveProject(Project *proj);
		
		// save project
		bool SaveProject(Project *proj);
		
		// save project with a new name
		bool SaveProjectAs(Project *proj, String const &path);

		// get current project
		Project *GetCurrentProject(void);

		// change handler
		Callback WhenChange;
		
		// serialization support -- just serializes splitters layouts
		void Serialize(Stream &s);
		
		// xml support -- stores opened projects
		void Xmlize(XmlIO &xml);
		
		// handler for changes in settings
		void SettingsChanged(void);
		
		// propagate theme to all projects
		void ThemeChanged(Theme const *t);
};

#endif
