#ifndef _FishIDE_SettingsDialogs_h_
#define _FishIDE_SettingsDialogs_h_

#include "Dialogs.h"
#include "AVersion.h"
#include "Theme.h"

class SettingsDialog : public WithSettingsLayout<TopWindow>
{
	private:
		String settingsBackup;
		
		String themesBackup;
		Theme currentTheme;
		int activeTheme;
	
		void userWarnCb(void);
	
	protected:
	
		WithSettingsCompilerLayout<ParentCtrl>	compiler;
		WithSettingsUploaderLayout<ParentCtrl>	uploader;
		WithSettingsEditorLayout<ParentCtrl>	editor;
		WithSettingsIdeLayout<ParentCtrl>		ide;
		WithSettingsThemeLayout<ParentCtrl>		theme;
		WithSettingsFormatterLayout<ParentCtrl>	formatter;
		WithSettingsLocationsLayout<ParentCtrl>	locations;
		
		WithSettingsFontsLayout<ParentCtrl>		fonts;
		WithSettingsColorsLayout<ParentCtrl>	colors;
		WithSettingsHlLayout<ParentCtrl>		hilight;
		
		// react to theme selection
		void themeDropCb(void);

		// fill themes droplist
		void fillThemeDrop(void);
		
		// fill theme dialogs
		void fillTheme(void);
		
		// store theme data into currenttheme
		void storeTheme(void);
		
		// themes buttons handlers
		void newThemeCb(void);
		void renameThemeCb(void);
		void removeThemeCb(void);
		void exportThemeCb(void);
		void importThemeCb(void);
		void testThemeCb(void);
		
		void astyleTest(void);
		void astyleDefaults(void);
		
		bool Accept(void);
		void Reject(void);
		
	public:
	
		typedef SettingsDialog CLASSNAME;
	
		// constructor
		SettingsDialog();
		
		// destructor
		~SettingsDialog();
};

#endif
