#ifndef _FishIDE_SourceTools_h_
#define _FishIDE_SourceTools_h_

#include <Core/Core.h>

using namespace Upp;

#include "AVersion.h"
#include "IdeFilePool.h"

class SourceTools
{
	private:
	
		// scan a string from a starting position
		// and find a #include statement
		static bool FindInclude(String s, int &startPos, int &endPos, String &inc);
	
		// scan all includes, retrieving also positions in string
		static bool FindIncludes(String const &s, Vector<String> &paths, Vector<int> &starts, Vector<int> &ends);

		// skip starting comments in string, return position of first non-comment line start
		// return insert position for code - negative if we need a \n before
		static int SkipStartingComments(String const &s);
	
	protected:
	
	public:
	
		// scan a string for include files
		// return an array of all #included files
		static Vector<String> ScanStringIncludes(String const &s);
		
		// scan a file for include files
		// return an array of all #included files
		static Vector<String> ScanIncludes(String const &path);
		
		// scan an array of source files gathering all includes
		static Vector<String> ScanIncludes(Vector<String> const &files);
		
		// check t files for timestamp - return true if first is newer
		static bool Newer(String const &str, String const &obj);
		
		// check first file against a list of files
		// return true if first is older of any of the others
		static bool Older(String const &str, Vector<String> const &objs);
		
		// get oldest filetime of a series of files
		static Time GetOldestTime(Vector<String> const &files);
		
		// get newest filetime of a series of files
		static Time GetNewestTime(Vector<String> const &files);
		
		// scan a file for function prototypes
		static Vector<String> scanPrototypes(String const &path);
		
		// insert some include files into a source file
		static bool InsertIncludes(String &s, Vector<String> const &includes);
		
		// remove some include files from a source file
		static bool RemoveIncludes(String &s, Vector<String> const &includes);
};

#endif
