#ifndef _FishIDE_Splash_h_
#define _FishIDE_Splash_h_

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

class Splash : public ParentCtrl
{
	private:
	
		// the splash image
		Image image;
		
		// scaled and cropped image to fit requested size
		// it's filled on FadeIn and destroyed after FadeOut
		Image scaledImage;

		// timer tick, in milliseconds
		int tickTime;
		
		// full splash size
		int percentSize;
		Size splashSize;
		
		// contents for about box
		RichTextCtrl contents;
		RichTextCtrl versionPane;
		
		// close aboutbox handle
		void AboutClose(int steps);

	protected:
	
		virtual void Paint(Draw &w);
		
		void ChildMouseEvent(Ctrl *child, int event, Point p, int zdelta, dword keyflags);
		Image MouseEvent(int event, Point p, int zdelta, dword keyflags);

	public:
		
		typedef Splash CLASSNAME;
		
		// constructor
		Splash();
		
		// sets max size of splash ctrl
		// defaults to 75% of screen size
		Splash &SetSize(int screenPercent = 75);
		
		// image setting
		Splash &SetImage(Image const &img);
		
		// sets tick time
		Splash &SetTickTime(int time);
		
		// fade in/out -- returns true if ok, false if already busy
		void FadeIn(int steps);
		void FadeOut(int steps);
		
		// about box behaviour
		void AboutBox(String const &cont, int inSteps, int outSteps);
		
		// version display
		void ShowVersion(String const &version);
		void HideVersion(void);
		
		Callback WhenCloseClick;
};

#endif
