#ifndef _FishIDE_Tool_h_
#define _FishIDE_Tool_h_

#include <Core/Core.h>

using namespace Upp;

class Package;

class Tool
{
	friend class Package;
	friend class PackagesClass;
	friend class Platform;
	friend class SettingsClass;
	
	public:

		struct ToolSystem : Moveable<ToolSystem>
		{
			// host type
			String _host;
			
			// tool url
			String _url;
			
			// archive file name
			String _archiveName;
			
			// archive checksum and size
			String _checksum;
			uint32_t _size;
		};

	private:
	
		// installed flag
		bool _installed;
		
		// owning package
		Package *_package;
	
		// tool name
		String _name;
		
		// tool version
		String _version;
		
		// system for this tool
		Vector<ToolSystem> _systems;
	
		// constructor
		Tool(Package *package);
		
		// parse platform data contained in a Value object
		bool ParseJSON(Value const &json);
		
		// get current OS system data, NULL if none
		ToolSystem const *GetSystem(void) const;
		
		// get local root folder
		String GetLocalFolder(void) const;
		
		// get local staging archive
		String GetStagingArchivePath(void) const;

		// check if is installed
		bool CheckInstall(void);
		
		// install (or reinstall) tool files
		bool Install(void);
		
		// remove tool files (and dependencies)
		bool Remove(void);
		
	protected:
	
	public:
	
		// destructor
		~Tool();
		
		// check if installed
		bool IsInstalled(void) const { return _installed; }
		
		// get owning package
		Package *GetPackage(void) const { return _package; }
		
		// get tool name
		String const &GetName(void) const { return _name; }
		
		// get tool version
		String const &GetVersion(void) const { return _version; }
		
		// get variables needed for build/upload
		VectorMap<String, String> GetVariables(void) const;
};

#endif
