#ifndef _UDP_SOCKET_H_
#define _UDP_SOCKET_H_

#include "IPAddress.h"

#ifdef PLATFORM_WIN32
	#define SOCKET_TYPE SOCKET
#else
	#define SOCKET_TYPE int
//	#define closesocket(fd) close(fd)
#endif

#define BUFFER_SIZE 20000

class UdpSocket : NoCopy
{
	private:
	
		// connection port
		uint16_t _port;
		
		// server socket (-1 if not listening)
		SOCKET_TYPE	_serverSocket;
		
		// flag indicating that we joined a multicast group
		bool _mcast;
		IPV4Address _mcastAddr;
		
	protected:
	
	public:
	
		// constructor
		UdpSocket(uint16_t port);
		
		// destructor
		~UdpSocket();
		
		// send data
		bool SendTo(IPV4Address host, uint16_t port, String const &data);
		
		// start listening for connections
		bool Listen(void);
		
		bool Listening(void) const { return _serverSocket != -1; }
		
		// stop listening for connections
		bool Stop(void);
		
		// check if data is available from server
		int Available(void);
		
		// read data from socket - return 0 bytes if none is available
		// on host and port the corresponding client's ones
		int Receive(IPV4Address &host, uint16_t &port, String &data);
		
		// join multicast group
		bool IGMPJoin(IPV4Address addr);
		
		// leave multicast group
		bool IGMPLeave(void);
};

#endif
