class TabBarCtrl : public TabBar
{
	public:
		struct Style : ChStyle<Style>
		{
			Color background;
		};

	private:
		VectorMap<Value, Ctrl *> ctrls;
		StaticRect pane;

	protected:
		const Style *style;
	
		virtual void CursorChanged();
		virtual void TabClosed(Value key);

	public:
		TabBarCtrl()
		{
			SetStyle(StyleDefault());
			Ctrl::Add(pane);
		}
		virtual void Layout()
		{
			TabBar::Layout();
			pane.SetRect(GetClientArea());
			pane.Color(style->background);
		}

		TabBarCtrl& AddCtrl(Ctrl &ctrl, Value key, Value value, Image icon = Null, String group = Null, bool make_active = false);
		TabBarCtrl& AddCtrl(Ctrl &ctrl, Value value, Image icon = Null, String group = Null, bool make_active = false);
		TabBarCtrl& InsertCtrl(int ix, Ctrl &ctrl, Value key, Value value, Image icon = Null, String group = Null, bool make_active = false);
		TabBarCtrl& InsertCtrl(int ix, Ctrl &ctrl, Value value, Image icon = Null, String group = Null, bool make_active = false);

		void 	RemoveCtrl(Value key);
		void 	RemoveCtrl(int ix);
		void 	RemoveCtrl(Ctrl &c);

		Ctrl *	GetCtrl(Value key);
		Ctrl *	GetCtrl(int ix);
		Ctrl *	GetCurrentCtrl();
		int		GetCurrentIndex();

		void 	SetCtrl(Value key);
		void 	SetCtrl(int ix);
		void 	SetCtrl(Ctrl &ctrl);

		static const Style& StyleDefault();
		TabBarCtrl&  SetStyle(const Style& s);

};
