//////////////////////////////////////////////////////////////////////////////////////
//																					//
//								FishinoSerial.h										//
//						Library for ESP8266 WiFi module								//
//					Created by Massimo Del Fedele, 2015								//
//																					//
//  Copyright (c) 2015, 2016 and 2017 Massimo Del Fedele.  All rights reserved.		//
//																					//
//	Redistribution and use in source and binary forms, with or without				//
//	modification, are permitted provided that the following conditions are met:		//
//																					//
//	- Redistributions of source code must retain the above copyright notice,		//
//	  this list of conditions and the following disclaimer.							//
//	- Redistributions in binary form must reproduce the above copyright notice,		//
//	  this list of conditions and the following disclaimer in the documentation		//
//	  and/or other materials provided with the distribution.						//
//																					//	
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"		//
//	AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE		//
//	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE		//
//	ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE		//
//	LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR				//
//	CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF			//
//	SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS		//
//	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN			//
//	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)			//
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE		//
//	POSSIBILITY OF SUCH DAMAGE.														//
//																					//
//	VERSION 1.0.0 - INITIAL VERSION													//
//	VERSION 2.0.0 - 06/01/2016 - REWROTE SPI INTERFACE AND ERROR HANDLING			//
//	VERSION 4.0.0 - 01/01/2017 - REWROTE SPI INTERFACE AND ERROR HANDLING			//
//	VERSION 5.1.0 - 04/05/2017 - USE NEW DEBUG LIBRARY								//
//	VERSION 5.2.0 - 20/05/2017 - USE NEW DEBUG LIBRARY								//
//  Version 6.0.0 -- June 2017 - USE NEW DEBUG LIBRARY								//
//  Version 7.0.0 -- June 2017 - REWROTE SPI INTERFACE								//
//  Version 7.0.1 -- June 2017 - FIXED BUG ON MEGA									//
//																					//
//////////////////////////////////////////////////////////////////////////////////////
#ifndef __FISHINOSERIAL_H
#define __FISHINOSERIAL_H

#define FishinoSerial __fishinoSerial()

class FishinoSerialClass : public Stream
{
	private:
	
	protected:
	
	public:
	
		// constructor
	    FishinoSerialClass();
	    
	    // destructor
	    ~FishinoSerialClass();
	    
	    // open serial port
	    void begin(uint32_t baud);
	    
	    // close serial port
	    void end(void);
	    
	    // get number of available bytes for reading
	    virtual int available(void);
	    
	    // peek a byte from serial port
	    virtual int peek(void);
	    
	    // read a byte from serial port
	    virtual int read(void);
	    
	    // flush serial port
	    virtual void flush(void);

		virtual size_t write(uint8_t);
		inline size_t write(unsigned long n) { return write((uint8_t)n); }
		inline size_t write(long n) { return write((uint8_t)n); }
		inline size_t write(unsigned int n) { return write((uint8_t)n); }
		inline size_t write(int n) { return write((uint8_t)n); }
		
		// pull in write(str) and write(buf, size) from Print
		using Print::write;
		
		operator bool() { return true; }
};

extern FishinoSerialClass &__fishinoSerial();

#endif
