#ifndef _FishinoXPT2046_h_
#define _FishinoXPT2046_h_

#include <SPI.h>


////////////////////////////////////////////////////////////////////////////////
// touch minimum raw value for pressed event to happen
// do not lower too much or you can get spurious presses
#define XPT2046_Z_THRESHOLD		50
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// calibration values -- given for a 2.8' 240x320 TFT display here
// can be calculated using FishinoTouchCalibrate example sketch
// for other screen sizes or to have a better precision on yours
// formula from raw value to scren value is
// SCREEN_VAL = (RAW_VAL + B) * 8 / A
// you can replace the values here or use FishinoXPT2046.calibrate() function
// inside your sketch to adapt to your display
const uint16_t XPT2046_WIDTH	=   240;
const uint16_t XPT2046_HEIGHT	=   320;
const int16_t XPT2046_AX		=  -117;
const int16_t XPT2046_BX		= -3786;
const int16_t XPT2046_AY		=    88;
const int16_t XPT2046_BY		=  -233;
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// connection pins for Fishino and Arduino on Fishino TFT shield
// if this library has to be used with another shield/breakout
// adapt connection pins using connect() display and touch functions
#if defined(_FISHINO_PIRANHA_) || defined(_FISHINO_PIRANHA_96M_)
	#define TFT_DC		7
	#define TFT_CS		2
	#define TOUCH_CS 	6
	#define TOUCH_IRQ	5
#elif defined(_FISHINO32_) || defined(_FISHINO32_96M_)
	#define TFT_DC		5
	#define TFT_CS		2
	#define TOUCH_CS	6
	#define TOUCH_IRQ	3
#elif defined(_FISHINO_UNO_)
	#define TFT_DC		5
	#define TFT_CS		2
	#define TOUCH_CS	6
	#define TOUCH_IRQ	3
#elif defined(_FISHINO_MEGA_)
	#define TFT_DC		5
	#define TFT_CS		2
	#define TOUCH_CS	6
	#define TOUCH_IRQ	3
#elif defined(_FISHINO_GUPPY_)
	#define TFT_DC		5
	#define TFT_CS		2
	#define TOUCH_CS	6
	#define TOUCH_IRQ	3
#else
	#define TFT_DC		5
	#define TFT_CS		2
	#define TOUCH_CS	6
	#define TOUCH_IRQ	3
#endif

struct TSPoint
{
	uint16_t x;
	uint16_t y;
	uint16_t pressure;
};

class FishinoXPT2046Class
{
	friend FishinoXPT2046Class &__GetFishinoXPT2046(void);
	friend void FishinoXPT2046_ISR(void);
	
	private:
	
		// connected flag
		bool _connected;
		
		// connection pins
		uint8_t _cs;
		uint8_t _irq;
		
		// touch sizes
		uint16_t _width;
		uint16_t _height;
		
		// display rotation (counterclockwse increasing)
		uint8_t _rotation;
		
		// last raw cursor positions
		uint16_t _x, _y;
		uint16_t _z;
		
		// calibration values
		int16_t _ax, _bx;
		int16_t _ay, _by;
		
		// last pressure value
		uint16_t _pressure;
		
		// touched since last query
		volatile bool _touched;
		
		// read some points, discards the extremes
		// and take the mean of internal ones
		int16_t readVal(uint8_t what);
		
		// constructor
		FishinoXPT2046Class();
		
		// update values from touch
		bool update(void);
		
	protected:
	
	public:
	
		// destructor
		~FishinoXPT2046Class();
		
		// connect to hardware ports
		void connect(uint8_t cs, uint8_t irq);
		
		// disconnect from hardware ports
		void disconnect(void);
		
		// set calibration values
		void calibrate(uint16_t w, uint16_t h, int16_t ax, int16_t bx, int16_t ay, int16_t by);
		
		// set default calibration values (see comments on top)
		void calibrate();
		
		// set display rotation (counterclockwise)
		void setRotation(uint8_t rot);
		
		// check if being touched
		bool touching(void);
		
		// read raw coordinates (as returned by XPT2046 chip)
		// useful only for calibration routines
		void readRaw(uint16_t &x, uint16_t &y, int16_t &z);
		
		// read calibrated coordinates (and pressure value)
		void read(uint16_t &x, uint16_t &y, uint16_t &pressure);
		void read(uint16_t &x, uint16_t &y);
		TSPoint read(void);
};

extern FishinoXPT2046Class &__GetFishinoXPT2046(void);

#define FishinoXPT2046 	__GetFishinoXPT2046()

#endif
