#include <FishinoEEPROM.h>

#define DEBUG_LEVEL_INFO
#include <FishinoDebug.h>

void dumpEEPROM(uint32_t start = 0, uint32_t size = -1)
{
	if(size == (uint32_t)-1)
		size = FishinoEEPROM.size();
	
	int j = 16;
	for(size_t i = start; i < size; i++)
	{
		if(j >= 16)
		{
			DEBUG_INFO_N("\n0x%04x : ", i);
			j = 0;
		}
		DEBUG_INFO_N("%02x ", FishinoEEPROM.read8u(i));
		j++;
	}
	DEBUG_INFO_N("\n------------------------------\n");
}

void setup()
{
	Serial.begin(115200);
	while(!Serial)
		;
	DEBUG_INFO_N("FishinoEEPROMTest\n\n");
	DEBUG_INFO_N("EEPROM Size       : %08d\n", FishinoEEPROM.size());
#ifdef _FISHINO_PIC32_
	DEBUG_INFO_N("EEPROM Page size  : %08d\n", FishinoEEPROM.pageSize());
	DEBUG_INFO_N("EEPROM Row size   : %08d\n", FishinoEEPROM.rowSize());
#endif
	DEBUG_INFO_N("\nErasing the device...");
	FishinoEEPROM.eraseAll();
	DEBUG_INFO_N("DONE\n");

	DEBUG_INFO_N("\nDump of first 100 bytes of erased device...");
	dumpEEPROM(1, 100);
	
	DEBUG_INFO_N("\nFilling first 100 bytes...");
	for(int i = 0; i < 100; i++)
		FishinoEEPROM.write8u(i, i);
	DEBUG_INFO_N("DONE\n");
	DEBUG_INFO_N("\nChecking first 100 bytes...");
	bool err = false;
	for(int i = 0; i < 100; i++)
	{
		if(FishinoEEPROM.read8u(i) != i)
		{
			DEBUG_INFO_N("ERROR\nError at byte #%d, expecting %u, found %u\n", i, i, FishinoEEPROM.read8u(i));
			err = true;
			break;
		}
	}
	if(!err)
		DEBUG_INFO_N("DONE\n");

	DEBUG_INFO_N("\nDump of first 100 bytes of written flash...");
	dumpEEPROM(1, 100);
	
	DEBUG_INFO_N("\nErasing the device...");
	FishinoEEPROM.eraseAll();
	DEBUG_INFO_N("\nFilling first 100 dwords, dword aligned...");
	for(int i = 0; i < 100; i++)
		FishinoEEPROM.write32u(i * 4, i);
	DEBUG_INFO_N("DONE\n");
	DEBUG_INFO_N("\nChecking first 100 dwords...");
	err = false;
	for(int i = 0; i < 100; i++)
	{
		if(FishinoEEPROM.read32u(i * 4) != (uint32_t)i)
		{
			DEBUG_INFO_N("ERROR\nError at dword #%d, expecting %u, found %u\n", i, i, FishinoEEPROM.read32u(i * 4));
			err = true;
			break;
		}
	}
	if(!err)
		DEBUG_INFO_N("DONE\n");
	
	DEBUG_INFO_N("\nErasing the device...");
	FishinoEEPROM.eraseAll();

	DEBUG_INFO_N("\nFilling first 100 dwords, NOT aligned...");
	for(int i = 0; i < 100; i++)
		FishinoEEPROM.write32u(i * 4 + 1, i);
	DEBUG_INFO_N("DONE\n");
	DEBUG_INFO_N("\nChecking first 100 dwords...");
	err = false;
	for(int i = 0; i < 100; i++)
	{
		if(FishinoEEPROM.read32u(i * 4 + 1) != (uint32_t)i)
		{
			DEBUG_INFO_N("ERROR\nError at dword #%d, expecting %u, found %u\n", i, i, FishinoEEPROM.read32u(i * 4 + 1));
			err = true;
			break;
		}
	}
	if(!err)
		DEBUG_INFO_N("DONE\n");
	
	DEBUG_INFO_N("\nDump of first 400 bytes of written flash...");
	dumpEEPROM(1, 400);
	
}

void loop()
{
}
