///////////////////////////////////////////////////////////////////
//   FishinoTimer library demo                                   //
//   Created by Massimo Del Fedele, February 15, 2019.           //
///////////////////////////////////////////////////////////////////
#include <FishinoFlash.h>
#include <FishinoTimer.h>

#define DEBUG_LEVEL_INFO
#include <FishinoDebug.h>

#if defined(_FISHINO_PIC32_)
	#define TIMERA Timer23
	#define TIMERB Timer45
#elif defined(_FISHINO_MEGA_) || defined(_FISHINO_MEGA_R2_)
	#define TIMERA Timer1
	#define TIMERB Timer3
#else
	#define TIMERA Timer1
	#define TIMERB Timer2
#endif

void timerA()
{
	static int i = 0;
	Serial << "TimerA triggered #" << ++i << " times!\n";
	
	// DO NOT USE DEBUG_INFO MACRO INSIDE INTERRUPTS!
//	DEBUG_INFO("TimerA triggered #%05d times!\n", ++i);
}

#if defined(_FISHINO_PIC32_) || defined(_FISHINO_MEGA_) || defined(_FISHINO_MEGA_R2_)
void timerB()
{
	static int i = 0;
	Serial << "TimerB triggered #" << ++i << " times!\n";

	// DO NOT USE DEBUG_INFO MACRO INSIDE INTERRUPTS!
//	DEBUG_INFO("TimerB triggered #%05d times!\n", ++i);
}
#endif

void setup(void)
{
	// initialize serial port
	Serial.begin(115200);
	while(!Serial)
		;
	
	DEBUG_INFO("FishinoTimer demo application\n");
	DEBUG_INFO("2 interrupt routines will be started\n");
	DEBUG_INFO("One with 0.5 seconds and another with 1 second period\n");
	DEBUG_INFO("Then something is printed in each interrupt\n\n");
	
	// connect the 2 interrupt routines
	TIMERA.attachInterrupt(timerA);
#if defined(_FISHINO_PIC32_) || defined(_FISHINO_MEGA_) || defined(_FISHINO_MEGA_R2_)
	TIMERB.attachInterrupt(timerB);
#endif
	
	// setup times
	bool res = true;
	res &= TIMERA.setPeriodMilliseconds(1000);
#if defined(_FISHINO_PIC32_) || defined(_FISHINO_MEGA_) || defined(_FISHINO_MEGA_R2_)
	res &= TIMERB.setPeriodMilliseconds(500);
#endif
	
	if(!res)
	{
		DEBUG_ERROR("Failed to setup timer's periods; try with 32 bit timer\n");
		while(1)
			;
	}
	
	// start timers
	TIMERA.start();
#if defined(_FISHINO_PIC32_) || defined(_FISHINO_MEGA_) || defined(_FISHINO_MEGA_R2_)
	TIMERB.start();
#endif
}

void loop()
{
}