//////////////////////////////////////////////////////////////////////////////////////
//						 		Tables.cpp											//
//																					//
//			Library to handle MotorFish closed loop stepper driver board			//
//																					//
//		Copyright (c) 2019 Massimo Del Fedele.  All rights reserved.				//
//																					//
//	Redistribution and use in source and binary forms, with or without				//
//	modification, are permitted provided that the following conditions are met:		//
//																					//
//	- Redistributions of source code must retain the above copyright notice,		//
//	  this list of conditions and the following disclaimer.							//
//	- Redistributions in binary form must reproduce the above copyright notice,		//
//	  this list of conditions and the following disclaimer in the documentation		//
//	  and/or other materials provided with the distribution.						//
//																					//	
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"		//
//	AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE		//
//	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE		//
//	ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE		//
//	LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR				//
//	CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF			//
//	SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS		//
//	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN			//
//	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)			//
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE		//
//	POSSIBILITY OF SUCH DAMAGE.														//
//																					//
//  Version 7.8.0 -- March 2019		Initial version									//
//																					//
//////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////
// Sine, cosine and phase tables for 64 level microstepping //
//////////////////////////////////////////////////////////////
#include "Tables.h"

// table for 64 microsteps!
const uint16_t _sineTable[] = {
		0,  1608,  3215,  4821,  6423,  8022,  9615, 11203, 12785, 14358, 15923, 17479, 19023, 20557, 22078, 23585,
	25079, 26557, 28019, 29465, 30892, 32302, 33691, 35061, 36409, 37735, 39039, 40319, 41574, 42805, 44010, 45189,
	46340, 47463, 48558, 49623, 50659, 51664, 52638, 53580, 54490, 55367, 56211, 57021, 57796, 58537, 59242, 59912,
	60546, 61143, 61704, 62227, 62713, 63161, 63570, 63942, 64275, 64570, 64825, 65042, 65219, 65357, 65456, 65515,
	65535, 65515, 65456, 65357, 65219, 65042, 64825, 64570, 64275, 63942, 63570, 63161, 62713, 62227, 61704, 61143,
	60546, 59912, 59242, 58537, 57796, 57021, 56211, 55367, 54490, 53580, 52638, 51664, 50659, 49623, 48558, 47463,
	46340, 45189, 44010, 42805, 41574, 40319, 39039, 37735, 36409, 35061, 33691, 32302, 30892, 29465, 28019, 26557,
	25079, 23585, 22078, 20557, 19023, 17479, 15923, 14358, 12785, 11203,  9615,  8022,  6423,  4821,  3215,  1608,
};
