///////////////////////////////////////////////////////////////////
//   Fishetta library example for Arduino                        //
//   Created by Emanuele Signoretta, May 04  , 2019.             //
//   Send push notification by using the Pushetta webapp.        //
///////////////////////////////////////////////////////////////////

#include <SPI.h>
#include <Ethernet.h>
#include <Fishetta.h>


//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
// CONFIGURATION DATA    -- ADAPT TO YOUR NETWORK !!!
// DATI DI CONFIGURAZIONE -- ADATTARE ALLA PROPRIA RETE WiFi !!!
// Enter a MAC address for your controller below.
// Inserisci qui sotto un indirizzo MAC per la tua scheda.
// Newer Ethernet shields have a MAC address printed on a sticker on the shield
// Le nuove scherde Ethernet hanno un indirizzo MAC stampato su uno sticker sulla scheda
byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };


// Set the static IP address to use if the DHCP fails to assign
// Imposta un indirizzo IP statico in caso dovesse fallire l'assegnazione tramite DHCP
IPAddress ip(192, 168, 0, 177);


const char * APIKEY  = "" ; // Put here your API key 
const char * CHANNEL  = ""; // Put here your channel name

//                    END OF CONFIGURATION DATA                      //
//                       FINE CONFIGURAZIONE                         //
///////////////////////////////////////////////////////////////////////


// define ip address if required
// NOTE : if your network is not of type 255.255.255.0 or your gateway is not xx.xx.xx.1
// you should set also both netmask and gateway
#ifdef IPADDR
  IPAddress ip(IPADDR);
  #ifdef GATEWAY
    IPAddress gw(GATEWAY);
  #else
    IPAddress gw(ip[0], ip[1], ip[2], 1);
  #endif
  #ifdef NETMASK
    IPAddress nm(NETMASK);
  #else
    IPAddress nm(255, 255, 255, 0);
  #endif
#endif

// this one is optional, just to show wifi connection details
// questa è opzionale, solo per mostrare i dettagli della connessione wifi
void printWifiStatus()
{
  // print the SSID of the network you're attached to:
  // stampa lo SSID della rete:
  Serial.print("SSID: ");
  Serial.println(Fishino.SSID());

  // print your WiFi shield's IP address:
  // stampa l'indirizzo IP della rete:
  IPAddress ip = Fishino.localIP();
  Serial << F("IP Address: ");
  Serial.println(ip);

  // print the received signal strength:
  // stampa la potenza del segnale di rete:
  long rssi = Fishino.RSSI();
  Serial << F("signal strength (RSSI):");
  Serial.print(rssi);
  Serial << F(" dBm\n");
}

Fishetta push(CHANNEL,APIKEY); 

void setup()
{
// Initialize serial and wait for port to open
  // Inizializza la porta seriale e ne attende l'apertura
  Serial.begin(115200);
  
  // only for Leonardo needed
  // necessario solo per la Leonardo
  while (!Serial)
    ;
 // start the Ethernet connection:
  Serial.println("Initialize Ethernet with DHCP:");
  if (Ethernet.begin(mac) == 0) {
    Serial.println("Failed to configure Ethernet using DHCP");
    // Check for Ethernet hardware present
    if (Ethernet.hardwareStatus() == EthernetNoHardware) {
      Serial.println("Ethernet shield was not found.  Sorry, can't run without hardware. :(");
      while (true) {
        delay(1); // do nothing, no point running without Ethernet hardware
      }
    }
    if (Ethernet.linkStatus() == LinkOFF) {
      Serial.println("Ethernet cable is not connected.");
    }
    // try to congifure using IP address instead of DHCP:
    Ethernet.begin(mac, ip);
  } else {
    Serial.print("  DHCP assigned IP ");
    Serial.println(Ethernet.localIP());
  }
  // give the Ethernet shield a second to initialize:
  delay(1000);
}

void loop()
{

if (push.sendPushNotification("Fishetta library test!")){
  String serial_print = "Sent push notification at ";
  serial_print += CHANNEL;
  serial_print += " channel !";
  Serial.println(serial_print.c_str());} 

delay(10000);

}
