//////////////////////////////////////////////////////////////////////////////////////
//																					//
//								RefCounted.h										//
//						Library for ESP8266 WiFi module								//
//					Created by Massimo Del Fedele, 2015								//
//																					//
//  Copyright (c) 2015, 2016 and 2017 Massimo Del Fedele.  All rights reserved.		//
//																					//
//	Redistribution and use in source and binary forms, with or without				//
//	modification, are permitted provided that the following conditions are met:		//
//																					//
//	- Redistributions of source code must retain the above copyright notice,		//
//	  this list of conditions and the following disclaimer.							//
//	- Redistributions in binary form must reproduce the above copyright notice,		//
//	  this list of conditions and the following disclaimer in the documentation		//
//	  and/or other materials provided with the distribution.						//
//																					//	
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"		//
//	AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE		//
//	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE		//
//	ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE		//
//	LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR				//
//	CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF			//
//	SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS		//
//	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN			//
//	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)			//
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE		//
//	POSSIBILITY OF SUCH DAMAGE.														//
//																					//
//	VERSION 1.0.0 - INITIAL VERSION													//
//	VERSION 2.0.0 - 06/01/2016 - REWROTE SPI INTERFACE AND ERROR HANDLING			//
//	VERSION 4.0.0 - 01/01/2017 - REWROTE SPI INTERFACE AND ERROR HANDLING			//
//	VERSION 5.1.0 - 04/05/2017 - USE NEW DEBUG LIBRARY								//
//	VERSION 5.2.0 - 20/05/2017 - USE NEW DEBUG LIBRARY								//
//	Version 6.0.0 -- June 2017 - USE NEW DEBUG LIBRARY								//
//	Version 7.0.0 -- June 2017 - REWROTE SPI INTERFACE								//
//	Version 7.0.1 -- June 2017 - FIXED BUG ON MEGA									//
//	Version 7.1.0 - 20/10/2017 - AVOID AUTOMATIC SOCKET CLOSE FOR DELETED CLIENTS	//
//	Version 7.3.0 - 17/12/2017 - ADD WIFI MODULE DEEP SLEEP COMMAND					//
//	Version 7.3.2 - 05/01/2018 - FIXED RSSI AND MAC HANDLING/DISPLAY				//
//	Version 8.0.0 - 25/04/2020 - UPDATED FOR FIRMWARE 8.0.0							//
//																					//
//////////////////////////////////////////////////////////////////////////////////////
#ifndef __REFCOUNTED_H
#define __REFCOUNTED_H

template<class S, class C> class RefCounted
{
	private:
	
		// reference count
		uint16_t _refCount;
		
		// the socket
		S _socket;
	
	protected:
	
	public:
	
		// increment reference count
		void addRef(void)
		{
//			FISHINO_SPI_ERROR_PRINT("ADDREF:%p", this);
			_refCount++;
		}
		
		// decrement reference count
		bool remRef(void)
		{
//			FISHINO_SPI_ERROR_PRINT("REMREF:%p", this);
			// ops...
			if(!_refCount)
				return false;
			
			_refCount--;
			if(!_refCount)
			{
// @@ TRY TO MATCH ARDUINO BEHAVIOUR
// DO NOY CLOSE SOCKET ON CLIENT DELETE
// @@ 2020/03/24 - reverted because of socket handling changes
				C::killSocket(_socket);
				delete this;
				return false;
			}
			return true;
		}
		
		// get the socket
		inline S getSocket(void) { return _socket; }
		
		// constructor
		RefCounted(S sock)
		{
			_socket = sock;
			_refCount = 1;
//			FISHINO_SPI_ERROR_PRINT("CREATE:%p", this);
		}
		
		// destructor
		virtual ~RefCounted()
		{
//			FISHINO_SPI_ERROR_PRINT("DESTROY:%p", this);
		}
};

#endif

