// Library : 'FishinoArtnet' -- File : 'FishinoArtnet.h'
// Created by FishIDE application 
/*The MIT License (MIT)
Copyright (c) 2014 Nathanaël Lécaudé
https://github.com/natcl/Artnet, http://forum.pjrc.com/threads/24688-Artnet-to-OctoWS2811
Copyright (c) 2016,2019 Stephan Ruloff
https://github.com/rstephan
Copyright (c) 2019 Emanuele Signoretta, modified to work on Fishino boards
https://github.com/signorettae
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
#ifndef __FISHINOARTNET_FISHINOARTNET_H
#define __FISHINOARTNET_FISHINOARTNET_H

    #include <Fishino.h>
    #include <FishinoUdp.h>

// UDP specific
#define ART_NET_PORT 6454
// Opcodes
#define ART_POLL 0x2000
#define ART_POLL_REPLY 0x2100
#define ART_DMX 0x5000
#define ART_SYNC 0x5200
// Buffers
#define MAX_BUFFER_ARTNET 530
// Packet
#define ART_NET_ID "Art-Net\0"
#define ART_DMX_START 18
/*
class FishinoArtnet
{
        public:
        
        	// constructor
		FishinoArtnet();
        
		void begin(String hostname = "");
		uint16_t read(void);
		// returns 1 for Ok, or 0 on problem 
		int write(void);
		int write(IPAddress ip);
		void setByte(uint16_t pos, uint8_t value);
		void printPacketHeader(void);
		void printPacketContent(void);

		// Return a pointer to the start of the DMX data
		inline uint8_t* getDmxFrame(void) {
			return artnetPacket + ART_DMX_START;
		}

		inline uint16_t getOpcode(void) {
			return opcode;
		}

		inline uint8_t getSequence(void) {
			return sequence;
		}

		inline uint16_t getUniverse(void) {
			return incomingUniverse;
		}

		inline void setUniverse(uint16_t universe) {
			outgoingUniverse = universe;
		}

		inline void setPhysical(uint8_t port) {
			physical = port;
		}

		[[deprecated]]
		inline void setPhisical(uint8_t port) {
			setPhysical(port);
		}

		inline uint16_t getLength(void) {
			return dmxDataLength;
		}

		inline void setLength(uint16_t len) {
			dmxDataLength = len;
		}

		inline void setArtDmxCallback(void (*fptr)(uint16_t universe, uint16_t length, uint8_t sequence, uint8_t* data)) {
			artDmxCallback = fptr;
		}

	private:
		uint16_t makePacket(void);

		FishinoUDP Udp;
		String host;
		uint8_t artnetPacket[MAX_BUFFER_ARTNET];
		uint16_t packetSize;
		uint16_t opcode;
		uint8_t sequence;
		uint8_t physical;
		uint16_t incomingUniverse;
		uint16_t outgoingUniverse;
		uint16_t dmxDataLength;
		void (*artDmxCallback)(uint16_t universe, uint16_t length, uint8_t sequence, uint8_t* data);
		static const char artnetId[];

	

	
	

};

#endif
*/

struct artnet_reply_s {
  uint8_t  id[8];
  uint16_t opCode;
  uint8_t  ip[4];
  uint16_t port;
  uint8_t  verH;
  uint8_t  ver;
  uint8_t  subH;
  uint8_t  sub;
  uint8_t  oemH;
  uint8_t  oem;
  uint8_t  ubea;
  uint8_t  status;
  uint8_t  etsaman[2];
  uint8_t  shortname[18];
  uint8_t  longname[64];
  uint8_t  nodereport[64];
  uint8_t  numbportsH;
  uint8_t  numbports;
  uint8_t  porttypes[4];//max of 4 ports per node
  uint8_t  goodinput[4];
  uint8_t  goodoutput[4];
  uint8_t  swin[4];
  uint8_t  swout[4];
  uint8_t  swvideo;
  uint8_t  swmacro;
  uint8_t  swremote;
  uint8_t  sp1;
  uint8_t  sp2;
  uint8_t  sp3;
  uint8_t  style;
  uint8_t  mac[6];
  uint8_t  bindip[4];
  uint8_t  bindindex;
  uint8_t  status2;
  uint8_t  filler[26];
} __attribute__((packed));

class FishinoArtnet
{
public:
  FishinoArtnet();

  void begin(byte mac[], byte ip[]);
  void begin();
  void setBroadcast(byte bc[]);
  void setBroadcast(IPAddress bc);
  uint16_t read();
  void printPacketHeader();
  void printPacketContent();

  // Return a pointer to the start of the DMX data
  inline uint8_t* getDmxFrame(void)
  {
    return artnetPacket + ART_DMX_START;
  }

  inline uint16_t getOpcode(void)
  {
    return opcode;
  }

  inline uint8_t getSequence(void)
  {
    return sequence;
  }

  inline uint16_t getUniverse(void)
  {
    return incomingUniverse;
  }

  inline uint16_t getLength(void)
  {
    return dmxDataLength;
  }

  inline IPAddress getRemoteIP(void)
  {
    return remoteIP;
  }

  inline void setArtDmxCallback(void (*fptr)(uint16_t universe, uint16_t length, uint8_t sequence, uint8_t* data, IPAddress remoteIP))
  {
    artDmxCallback = fptr;
  }

  inline void setArtSyncCallback(void (*fptr)(IPAddress remoteIP))
  {
    artSyncCallback = fptr;
  }

private:
  uint8_t  node_ip_address[4];
  uint8_t  id[8];

  FishinoUDP Udp;

  struct artnet_reply_s ArtPollReply;


  uint8_t artnetPacket[MAX_BUFFER_ARTNET];
  uint16_t packetSize;
  IPAddress broadcast;
  uint16_t opcode;
  uint8_t sequence;
  uint16_t incomingUniverse;
  uint16_t dmxDataLength;
  IPAddress remoteIP;
  void (*artDmxCallback)(uint16_t universe, uint16_t length, uint8_t sequence, uint8_t* data, IPAddress remoteIP);
  void (*artSyncCallback)(IPAddress remoteIP);
};

#endif
